/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.enchanter;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.block.MultiblockCrafter;
import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.blocks.InWorldInteractionBlockEntity;
import earth.terrarium.pastel.blocks.item_bowl.ItemBowlBlockEntity;
import earth.terrarium.pastel.blocks.upgrade.Upgradeable;
import earth.terrarium.pastel.capabilities.ExperienceHandler;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.capabilities.SidedCapabilityProvider;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.capabilities.item.StackHandlerView;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.helpers.level.ExperienceHelper;
import earth.terrarium.pastel.networking.s2c_payloads.PlayBlockBoundSoundInstancePayload;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.particle.effect.ColoredSparkleRisingParticleEffect;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.recipe.SimpleRecipeInput;
import earth.terrarium.pastel.recipe.enchanter.EnchanterCraftingRecipe;
import earth.terrarium.pastel.recipe.enchanter.EnchanterRecipe;
import earth.terrarium.pastel.recipe.enchanter.EnchantmentUpgradeRecipe;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelItemTags;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchanterBlockEntity
extends InWorldInteractionBlockEntity
implements MultiblockCrafter,
SidedCapabilityProvider {
    public static final String ITEM_TRANS = "container.pastel.rei.enchantment_upgrade.required_item_count";
    public static final String LEVEL_TRANS = "container.pastel.rei.enchantment_upgrade.level";
    public static final String OVERCHANTING_TOOLTIP = "container.pastel.rei.enchantment_upgrade.tooltip";
    public static final String CYCLING = "container.pastel.rei.enchantment_upgrade.button";
    public static final List<Vec3i> OFFSETS = new ArrayList<Vec3i>(){
        {
            this.add(new Vec3i(5, 0, -3));
            this.add(new Vec3i(5, 0, 3));
            this.add(new Vec3i(3, 0, 5));
            this.add(new Vec3i(-3, 0, 5));
            this.add(new Vec3i(-5, 0, 3));
            this.add(new Vec3i(-5, 0, -3));
            this.add(new Vec3i(-3, 0, -5));
            this.add(new Vec3i(3, 0, -5));
        }
    };
    public static final int CENTER = 0;
    public static final int XP_STORAGE = 1;
    protected UUID ownerUUID;
    protected boolean conflictEnchanting;
    protected boolean overenchanting;
    private boolean wasCrafting;
    protected FriendlyStackHandler inputs;
    private Upgradeable.UpgradeHolder upgrades;
    private Optional<RecipeHolder<? extends EnchanterRecipe>> cachedRecipe = Optional.empty();
    private Optional<EnchantingData> enchData = Optional.empty();
    private int craftingTime;
    private EnchanterMode mode = EnchanterMode.IDLE;
    @Nullable
    private Direction itemFacing;

    public EnchanterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.ENCHANTER.get(), pos, state, 2);
        this.inputs = new FriendlyStackHandler(10);
        this.inventory.addListener(i -> this.inventoryChanged());
    }

    private void tickServer() {
        if (this.level == null || this.level.isClientSide() || this.mode == EnchanterMode.IDLE) {
            return;
        }
        if (this.cachedRecipe.isEmpty() && this.mode.recipeBased) {
            this.clearRecipe();
            return;
        }
        if (this.mode == EnchanterMode.ENCHANTING && this.enchData.isEmpty() && !this.findEnchantingData()) {
            this.clearRecipe();
            return;
        }
        if (this.upgrades == null) {
            this.calculateUpgrades();
        }
        this.wasCrafting = true;
        this.craftingTime -= this.upgrades.getSpeedDelta(this.level.getRandom());
        if (this.level.getGameTime() % 12L == 0L) {
            this.level.playSound(null, this.worldPosition, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.8f * PastelCommon.CONFIG.BlockSoundVolume, 0.8f + this.level.getRandom().nextFloat() * 0.4f);
        }
        if (this.craftingTime > 0) {
            return;
        }
        if (this.mode.recipeBased) {
            EnchanterRecipe recipe = (EnchanterRecipe)this.cachedRecipe.get().value();
            this.finalizeCrafting(recipe);
        } else {
            this.finalizeEnchanting();
        }
    }

    private void tickClient() {
        if (this.level == null || this.mode == EnchanterMode.IDLE) {
            return;
        }
        RandomSource random = this.level.getRandom();
        if (this.level.random.nextFloat() < 0.2f) {
            float randomX = 0.2f + random.nextFloat() * 0.6f;
            float randomZ = 0.2f + random.nextFloat() * 0.6f;
            float randomY = -0.1f + random.nextFloat() * 0.4f;
            this.level.addParticle((ParticleOptions)ColoredCraftingParticleEffect.LIME, (double)((float)this.worldPosition.getX() + randomX), (double)this.worldPosition.getY() + 2.5 + (double)randomY, (double)((float)this.worldPosition.getZ() + randomZ), 0.0, -0.1, 0.0);
        }
        if (this.level.getGameTime() % 12L == 0L) {
            this.spawnCraftingOrbs();
        }
    }

    private void finalizeCrafting(EnchanterRecipe recipe) {
        ItemStack center;
        double scaling = this.mode == EnchanterMode.UPGRADING ? (double)this.getCenterLevel((EnchantmentUpgradeRecipe)recipe) : 1.0;
        ItemStack output = recipe.assemble(new SimpleRecipeInput(this.inputs), (HolderLookup.Provider)this.level.registryAccess());
        recipe.consumeIngredients(this, (HolderLookup.Provider)this.level.registryAccess(), scaling);
        if (!recipe.noDiscounts()) {
            output.setCount(Support.chanceRound((float)output.getCount() * this.upgrades.getEffectiveValue(Upgradeable.UpgradeType.YIELD), this.level.random));
        }
        if ((center = this.getCenterStack()).getCount() > 1) {
            MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(this.level, this.worldPosition, output, output.getCount(), MultiblockCrafter.RECIPE_STACK_VELOCITY);
            center.shrink(1);
        } else {
            this.inputs.setStackInSlot(0, output);
        }
        Optional required = recipe.requiredAdvancementIdentifier;
        if (this.mode == EnchanterMode.CRAFTING) {
            assert (recipe instanceof EnchanterCraftingRecipe);
            Support.areaCriterion((ServerLevel)this.level, 18, this.getBlockPos(), required, p -> PastelCriteria.ENCHANTER_CRAFTING.trigger((ServerPlayer)p, output, ((EnchanterCraftingRecipe)recipe).getRequiredExperience()));
        } else {
            Support.areaCriterion((ServerLevel)this.level, 18, this.getBlockPos(), required, p -> PastelCriteria.ENCHANTER_UPGRADING.trigger((ServerPlayer)p, EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)output), ((EnchantmentUpgradeRecipe)recipe).getXpScaling().apply(scaling)));
        }
        this.finalize(PastelSounds.ENCHANTER_FINISH);
    }

    private void finalizeEnchanting() {
        if (this.enchData.isEmpty()) {
            throw new IllegalStateException("Enchantment finalization reached with empty enchantment data? (what?)");
        }
        EnchantingData data = this.enchData.get();
        ItemStack target = !this.getCenterStack().is(PastelItemTags.ENCHANTABLE_BOOKS) ? this.getCenterStack() : Items.ENCHANTED_BOOK.getDefaultInstance();
        data.enchantments.forEach((holder, lv) -> Ench.addOrUpgradeEnchantment(target, (Holder<Enchantment>)holder, lv, true, true));
        this.inputs.setStackInSlot(0, target);
        this.getXpStorage().ifPresent(h -> h.extract(data.xpCost, false));
        this.finalize(SoundEvents.ENCHANTMENT_TABLE_USE);
        this.updateVanillaStats(target, data.xpCost);
        Support.areaCriterion((ServerLevel)this.level, 18, this.getBlockPos(), Optional.empty(), p -> PastelCriteria.ENCHANTER_ENCHANTING.trigger((ServerPlayer)p, target, data.xpCost));
    }

    private void updateRecipeAndMode() {
        if (this.findRecipe(PastelRecipeTypes.ENCHANTER)) {
            assert (this.cachedRecipe.isPresent());
            this.craftingTime = ((EnchanterRecipe)this.cachedRecipe.get().value()).getCraftingTime(1.0);
            this.mode = EnchanterMode.CRAFTING;
            this.enchData = Optional.empty();
        } else if (this.findRecipe(PastelRecipeTypes.ENCHANTMENT_UPGRADE)) {
            EnchantmentUpgradeRecipe recipe = (EnchantmentUpgradeRecipe)this.cachedRecipe.get().value();
            if (!this.canUpgrade(recipe)) {
                this.clearRecipe();
            } else {
                this.craftingTime = recipe.getCraftingTime(this.getCenterLevel(recipe)) * 5;
                this.mode = EnchanterMode.UPGRADING;
                this.enchData = Optional.empty();
            }
        } else if (this.findEnchantingData()) {
            assert (this.enchData.isPresent());
            this.mode = EnchanterMode.ENCHANTING;
            this.craftingTime = this.enchData.get().enchantments.size() * 60;
            this.cachedRecipe = Optional.empty();
        } else {
            this.clearRecipe();
        }
        if (this.craftingTime > 0 && !this.wasCrafting) {
            PlayBlockBoundSoundInstancePayload.sendPlayBlockBoundSoundInstance(PastelSounds.ENCHANTER_WORKING, (ServerLevel)this.level, this.worldPosition, Integer.MAX_VALUE);
        }
    }

    private boolean findEnchantingData() {
        ItemStack center = this.getCenterStack();
        if (center.isEmpty()) {
            return false;
        }
        boolean gilded = center.is(PastelItems.GILDED_BOOK);
        Object2IntArrayMap enchants = new Object2IntArrayMap();
        for (int slot = 2; slot < 10; ++slot) {
            ItemStack stack = this.inputs.getStackInSlot(slot);
            boolean isBook = stack.is(Items.ENCHANTED_BOOK);
            if (stack.isEmpty() || !gilded && !isBook) continue;
            enchants.putAll(Ench.getUsableEnchants(stack, center, center.is(PastelItemTags.ENCHANTABLE_BOOKS), this.conflictEnchanting));
            if (gilded && !enchants.isEmpty()) break;
        }
        if (enchants.isEmpty()) {
            return false;
        }
        int cost = 0;
        int enchantability = center.getEnchantmentValue();
        for (Object2IntMap.Entry entry : enchants.object2IntEntrySet()) {
            cost += Ench.getEnchantmentCost((Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue(), enchantability);
        }
        if (gilded) {
            cost *= 2;
        }
        int finalCost = cost;
        if (!this.getXpStorage().map(s -> s.extract(finalCost, true) == finalCost).orElse(false).booleanValue()) {
            return false;
        }
        this.enchData = Optional.of(new EnchantingData((Object2IntMap<Holder<Enchantment>>)enchants, cost));
        return true;
    }

    private Optional<ExperienceHandler> getXpStorage() {
        assert (this.level != null);
        return Optional.ofNullable((ExperienceHandler)this.getXPStack().getCapability(PastelCapabilities.Misc.XP, (Object)this.level.registryAccess()));
    }

    @NotNull
    private ItemStack getCenterStack() {
        return this.inputs.getStackInSlot(0);
    }

    @NotNull
    private ItemStack getXPStack() {
        return this.inputs.getStackInSlot(1);
    }

    private void clearRecipe() {
        PlayBlockBoundSoundInstancePayload.sendCancelBlockBoundSoundInstance((ServerLevel)this.level, this.worldPosition);
        this.cachedRecipe = Optional.empty();
        this.enchData = Optional.empty();
        this.mode = EnchanterMode.IDLE;
        this.craftingTime = 0;
        this.wasCrafting = false;
    }

    private void updateVanillaStats(ItemStack resultStack, int experience) {
        int levels = ExperienceHelper.getLevelForExperience(experience);
        Optional<ServerPlayer> player = this.getOwner();
        player.ifPresent(p -> {
            p.awardStat(Stats.ENCHANT_ITEM);
            CriteriaTriggers.ENCHANTED_ITEM.trigger(p, resultStack, levels);
        });
    }

    private Optional<ServerPlayer> getOwner() {
        return Optional.ofNullable((ServerPlayer)PlayerOwned.getPlayerEntityIfOnline(this.ownerUUID));
    }

    private void finalize(SoundEvent sound) {
        this.level.playSound(null, this.worldPosition, sound, SoundSource.BLOCKS, 1.334f, Support.varFloatCentered(this.level.random, 0.25f));
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)this.level, this.worldPosition.getCenter(), ColoredSparkleRisingParticleEffect.LIME, 75, new Vec3(0.5, 0.5, 0.5), new Vec3(0.1, -0.1, 0.1));
        this.updateRecipeAndMode();
        this.syncInventories();
        this.updateInClientWorld();
    }

    public FriendlyStackHandler getInputs() {
        return this.inputs;
    }

    public Upgradeable.UpgradeHolder getUpgrades() {
        return this.upgrades;
    }

    private void spawnCraftingOrbs() {
        assert (this.level != null);
        for (Vec3i offset : OFFSETS) {
            BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.offset(offset));
            if (!(blockEntity instanceof ItemBowlBlockEntity)) continue;
            ItemBowlBlockEntity bowl = (ItemBowlBlockEntity)blockEntity;
            bowl.spawnOrbParticles(this.worldPosition.getCenter());
        }
    }

    private boolean canUpgrade(EnchantmentUpgradeRecipe recipe) {
        int level = this.getCenterLevel(recipe);
        if (this.overenchanting) {
            return level < recipe.getLevelCap();
        }
        return recipe.isInNormalRange(level);
    }

    private boolean findRecipe(RecipeType<? extends EnchanterRecipe> type) {
        assert (this.level != null);
        this.cachedRecipe = this.level.getRecipeManager().getRecipeFor(type, (RecipeInput)new SimpleRecipeInput(this.inputs), this.level);
        if (this.cachedRecipe.isPresent() && !((EnchanterRecipe)this.cachedRecipe.get().value()).canPlayerCraft(this.getOwnerIfOnline())) {
            this.cachedRecipe = Optional.empty();
        }
        return this.cachedRecipe.isPresent();
    }

    private int getCenterLevel(EnchantmentUpgradeRecipe recipe) {
        return ((ItemEnchantments)this.getCenterStack().getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).getLevel(recipe.getEnchantment());
    }

    private void syncInventories() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        this.inventory.getInternalList().set(0, (Object)this.getCenterStack());
        this.inventory.getInternalList().set(1, (Object)this.getXPStack());
        for (int slot = 2; slot < this.inputs.getSlots(); ++slot) {
            this.setItemBowlStack(this.inputs.getStackInSlot(slot), this.level, this.bowlPos(slot));
        }
        this.updateInClientWorld();
    }

    public void inventoryChanged() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        this.inputs.clear();
        this.inputs.setStackInSlot(0, this.getItem(0));
        this.inputs.setStackInSlot(1, this.getItem(1));
        for (int slot = 2; slot < this.inputs.getSlots(); ++slot) {
            this.inputs.setStackInSlot(slot, this.getItemBowlStack(this.level, this.bowlPos(slot)));
        }
        this.updateRecipeAndMode();
        this.setChanged();
        this.updateInClientWorld();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.craftingTime = nbt.getInt("crafting_time");
        this.mode = EnchanterMode.values()[nbt.getInt("mode")];
        this.conflictEnchanting = nbt.getBoolean("owner_can_apply_conflicting_enchantments");
        this.overenchanting = nbt.getBoolean("owner_can_overenchant");
        this.inputs = new FriendlyStackHandler(10);
        this.inputs.deserializeNBT(registryLookup, nbt.getCompound("inventory"));
        if (nbt.contains("item_facing", 8)) {
            this.itemFacing = Direction.valueOf((String)nbt.getString("item_facing").toUpperCase(Locale.ROOT));
        }
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.cachedRecipe = Optional.ofNullable(MultiblockCrafter.getRecipeEntryFromNbt(this.level, nbt));
        this.upgrades = nbt.contains("Upgrades", 9) ? Upgradeable.UpgradeHolder.fromNbt(nbt.getList("Upgrades", 10)) : new Upgradeable.UpgradeHolder();
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("crafting_time", this.craftingTime);
        nbt.putInt("mode", this.mode.ordinal());
        nbt.putBoolean("owner_conflictEnchants", this.conflictEnchanting);
        nbt.putBoolean("owner_overEnchants", this.overenchanting);
        nbt.put("inventory", (Tag)this.inputs.serializeNBT(registryLookup));
        if (this.itemFacing != null) {
            nbt.putString("item_facing", this.itemFacing.toString().toUpperCase(Locale.ROOT));
        }
        if (this.upgrades != null) {
            nbt.put("Upgrades", (Tag)this.upgrades.toNbt());
        }
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        this.cachedRecipe.ifPresent(recipeHolder -> nbt.putString("CurrentRecipe", recipeHolder.id().toString()));
    }

    @Override
    public void updateInClientWorld() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 4);
        }
    }

    public Direction getItemFacingDirection() {
        return Objects.requireNonNullElse(this.itemFacing, Direction.NORTH);
    }

    public void setItemFacingDirection(Direction facingDirection) {
        this.itemFacing = facingDirection;
    }

    public ItemStack getItemBowlStack(Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof ItemBowlBlockEntity) {
            ItemBowlBlockEntity bowl = (ItemBowlBlockEntity)blockEntity;
            return bowl.getItem(0);
        }
        return ItemStack.EMPTY;
    }

    public void setItemBowlStack(ItemStack stack, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof ItemBowlBlockEntity) {
            ItemBowlBlockEntity bowl = (ItemBowlBlockEntity)blockEntity;
            bowl.setItem(0, stack);
            bowl.setChanged();
            bowl.updateInClientWorld();
        }
    }

    @NotNull
    private BlockPos bowlPos(int slot) {
        return this.worldPosition.offset(OFFSETS.get(slot - 2));
    }

    public void playSound(SoundEvent soundEvent, float volume) {
        if (this.level == null) {
            return;
        }
        this.level.playSound(null, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), soundEvent, SoundSource.BLOCKS, volume, 0.9f + this.level.random.nextFloat() * 0.15f);
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(Player playerEntity) {
        this.ownerUUID = playerEntity.getUUID();
        this.conflictEnchanting = DatabankUtils.hasAdvancement((Player)playerEntity, (ResourceLocation)PastelAdvancements.APPLY_CONFLICTING_ENCHANTMENTS);
        this.overenchanting = DatabankUtils.hasAdvancement((Player)playerEntity, (ResourceLocation)PastelAdvancements.OVERENCHANTING);
        this.setChanged();
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.setChanged();
    }

    @Override
    public void calculateUpgrades() {
        this.upgrades = Upgradeable.calculateUpgradeMods4(this.level, this.worldPosition, 3, 0, this.ownerUUID);
        this.setChanged();
    }

    @Override
    public Upgradeable.UpgradeHolder getUpgradeHolder() {
        return this.upgrades;
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        return new StackHandlerView(this.inventory, 0);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, EnchanterBlockEntity enchanter) {
        enchanter.tickClient();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, EnchanterBlockEntity enchanter) {
        enchanter.tickServer();
    }

    private static enum EnchanterMode {
        IDLE(false),
        CRAFTING(true),
        UPGRADING(true),
        ENCHANTING(false);

        private final boolean recipeBased;

        private EnchanterMode(boolean recipeBased) {
            this.recipeBased = recipeBased;
        }
    }

    private record EnchantingData(Object2IntMap<Holder<Enchantment>> enchantments, int xpCost) {
    }
}

