/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.enchanter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import earth.terrarium.pastel.blocks.enchanter.EnchanterBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Quaternionf;

public class EnchanterBlockEntityRenderer
implements BlockEntityRenderer<EnchanterBlockEntity> {
    protected static final double ITEM_STACK_RENDER_HEIGHT = (double)0.95f;
    protected static EntityRenderDispatcher dispatcher;

    public EnchanterBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
    }

    public void render(EnchanterBlockEntity blockEntity, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumerProvider, int light, int overlay) {
        ItemStack experienceItemStack;
        ItemStack stack = blockEntity.getItem(0);
        if (!stack.isEmpty() && blockEntity.getItemFacingDirection() != null) {
            Direction itemFacingDirection = blockEntity.getItemFacingDirection();
            poseStack.pushPose();
            switch (itemFacingDirection) {
                case NORTH: {
                    poseStack.translate(0.5, (double)0.95f, 0.7);
                    poseStack.mulPose(Axis.XP.rotationDegrees(270.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    break;
                }
                case SOUTH: {
                    poseStack.translate(0.5, (double)0.95f, 0.3);
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    break;
                }
                case EAST: {
                    poseStack.translate(0.3, (double)0.95f, 0.5);
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(270.0f));
                    break;
                }
                case WEST: {
                    poseStack.translate(0.7, (double)0.95f, 0.5);
                    poseStack.mulPose(Axis.XP.rotationDegrees(270.0f));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    break;
                }
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, poseStack, vertexConsumerProvider, blockEntity.getLevel(), 0);
            poseStack.popPose();
        }
        if (!(experienceItemStack = blockEntity.getItem(1)).isEmpty()) {
            float t = (float)(blockEntity.getLevel().getGameTime() % 50000L) + tickDelta;
            Vec3 cameraPos = EnchanterBlockEntityRenderer.dispatcher.camera.getPosition();
            Vec3 refPos = blockEntity.getBlockPos().getCenter();
            double xOffset = refPos.x - cameraPos.x;
            double zOffset = refPos.z - cameraPos.z;
            Quaternionf rot = Axis.YP.rotation((float)Mth.atan2((double)xOffset, (double)zOffset));
            poseStack.pushPose();
            poseStack.translate(0.5, 2.5 + (double)(Mth.sin((float)(t / 15.0f)) / 5.0f), 0.5);
            poseStack.mulPose(rot);
            if (cameraPos.closerThan((Position)refPos, 9.0)) {
                poseStack.mulPose(Axis.YP.rotationDegrees(Math.clamp((float)0.0f, (float)360.0f, (float)(t * 10.0f % 1800.0f))));
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(experienceItemStack, ItemDisplayContext.FIXED, 0xF000F0, overlay, poseStack, vertexConsumerProvider, blockEntity.getLevel(), 0);
            poseStack.popPose();
        }
    }
}

