/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.ender;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.ender.EnderDropperBlockEntity;
import earth.terrarium.pastel.inventories.GenericPastelContainerScreenHandler;
import earth.terrarium.pastel.inventories.ScreenBackgroundVariant;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class EnderDropperBlock
extends DispenserBlock {
    public static final MapCodec<EnderDropperBlock> CODEC = EnderDropperBlock.simpleCodec(EnderDropperBlock::new);
    private static final DispenseItemBehavior BEHAVIOR = new DefaultDispenseItemBehavior();

    public EnderDropperBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends EnderDropperBlock> codec() {
        return CODEC;
    }

    protected DispenseItemBehavior getDispenseMethod(Level world, ItemStack stack) {
        return BEHAVIOR;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnderDropperBlockEntity(pos, state);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (placer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)placer;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof EnderDropperBlockEntity) {
                EnderDropperBlockEntity dropperEntity = (EnderDropperBlockEntity)blockEntity;
                dropperEntity.setOwner((Player)serverPlayer);
                blockEntity.setChanged();
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof EnderDropperBlockEntity) {
            EnderDropperBlockEntity enderDropperBlockEntity = (EnderDropperBlockEntity)blockEntity;
            if (!enderDropperBlockEntity.hasOwner()) {
                enderDropperBlockEntity.setOwner(player);
            }
            if (enderDropperBlockEntity.isOwner(player)) {
                PlayerEnderChestContainer enderChestInventory = player.getEnderChestInventory();
                player.openMenu((MenuProvider)new SimpleMenuProvider((i, playerInventory, playerEntity) -> GenericPastelContainerScreenHandler.createGeneric9x3(i, playerInventory, (Container)enderChestInventory, ScreenBackgroundVariant.EARLYGAME), enderDropperBlockEntity.getDefaultName()));
                PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"block.pastel.ender_dropper_with_owner", (Object[])new Object[]{enderDropperBlockEntity.getOwnerName()}), true);
            }
        }
        return InteractionResult.CONSUME;
    }

    protected void dispenseFrom(ServerLevel level, BlockState state, BlockPos pos) {
        EnderDropperBlockEntity dropper = level.getBlockEntity(pos, (BlockEntityType)PastelBlockEntities.ENDER_DROPPER.get()).orElse(null);
        if (dropper == null) {
            return;
        }
        BlockSource blockPointer = new BlockSource(level, pos, state, (DispenserBlockEntity)dropper);
        int i = dropper.getRandomSlot(level.random);
        if (i < 0) {
            level.levelEvent(1001, pos, 0);
        } else {
            ItemStack itemStack = dropper.getItem(i);
            if (!itemStack.isEmpty()) {
                Direction direction = (Direction)level.getBlockState(pos).getValue((Property)FACING);
                if (level.getBlockState(pos.relative(direction)).isAir()) {
                    ItemStack itemStack3 = BEHAVIOR.dispense(blockPointer, itemStack);
                    dropper.setItem(i, itemStack3);
                } else {
                    IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos.relative(direction), (Object)direction.getOpposite());
                    if (handler != null) {
                        assert (dropper.getOwnerIfOnline() != null);
                        ItemStack moved = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)itemStack.copyWithCount(1), (boolean)false);
                        if (moved.isEmpty()) {
                            itemStack.shrink(1);
                            return;
                        }
                    }
                    level.levelEvent(1001, pos, 0);
                }
            }
        }
    }
}

