/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.ender;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.ender.EnderHopperBlockEntity;
import earth.terrarium.pastel.inventories.GenericPastelContainerScreenHandler;
import earth.terrarium.pastel.inventories.ScreenBackgroundVariant;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EnderHopperBlock
extends BaseEntityBlock {
    public static final MapCodec<EnderHopperBlock> CODEC = EnderHopperBlock.simpleCodec(EnderHopperBlock::new);
    private final VoxelShape TOP_SHAPE = EnderHopperBlock.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final VoxelShape MIDDLE_SHAPE = EnderHopperBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private final VoxelShape OUTSIDE_SHAPE = Shapes.or((VoxelShape)this.MIDDLE_SHAPE, (VoxelShape)this.TOP_SHAPE);
    private final VoxelShape INSIDE_SHAPE = EnderHopperBlock.box((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private final VoxelShape DEFAULT_SHAPE = Shapes.join((VoxelShape)this.OUTSIDE_SHAPE, (VoxelShape)this.INSIDE_SHAPE, (BooleanOp)BooleanOp.ONLY_FIRST);
    private final VoxelShape DOWN_SHAPE = Shapes.or((VoxelShape)this.DEFAULT_SHAPE, (VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));
    private final VoxelShape DOWN_RAYCAST_SHAPE = this.INSIDE_SHAPE;

    public EnderHopperBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends EnderHopperBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnderHopperBlockEntity(pos, state);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (placer instanceof ServerPlayer && (blockEntity = world.getBlockEntity(pos)) instanceof EnderHopperBlockEntity) {
            ((EnderHopperBlockEntity)blockEntity).setOwner((Player)((ServerPlayer)placer));
            blockEntity.setChanged();
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.DOWN_SHAPE;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter world, BlockPos pos) {
        return this.DOWN_RAYCAST_SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? null : EnderHopperBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PastelBlockEntities.ENDER_HOPPER.get()), EnderHopperBlockEntity::serverTick);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        this.updateEnabled(world, pos, state);
    }

    private void updateEnabled(Level world, BlockPos pos, BlockState state) {
        boolean bl;
        boolean bl2 = bl = !world.hasNeighborSignal(pos);
        if (bl != (Boolean)state.getValue((Property)HopperBlock.ENABLED)) {
            world.setBlock(pos, (BlockState)state.setValue((Property)HopperBlock.ENABLED, (Comparable)Boolean.valueOf(bl)), 4);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)world, (BlockPos)pos);
        super.onRemove(state, world, pos, newState, moved);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof EnderHopperBlockEntity) {
            EnderHopperBlockEntity enderHopperBlockEntity = (EnderHopperBlockEntity)blockEntity;
            EnderHopperBlockEntity.onEntityCollided(pos, entity, enderHopperBlockEntity);
        }
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HopperBlock.ENABLED});
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof EnderHopperBlockEntity) {
            EnderHopperBlockEntity enderHopperBlockEntity = (EnderHopperBlockEntity)blockEntity;
            if (!enderHopperBlockEntity.hasOwner()) {
                enderHopperBlockEntity.setOwner(player);
            }
            if (enderHopperBlockEntity.isOwner(player)) {
                PlayerEnderChestContainer enderChestInventory = player.getEnderChestInventory();
                player.openMenu((MenuProvider)new SimpleMenuProvider((i, playerInventory, playerEntity) -> GenericPastelContainerScreenHandler.createGeneric9x3(i, playerInventory, (Container)enderChestInventory, ScreenBackgroundVariant.EARLYGAME), enderHopperBlockEntity.getContainerName()));
                player.awardStat(Stats.OPEN_ENDERCHEST);
                PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"block.pastel.ender_hopper_with_owner", (Object[])new Object[]{enderHopperBlockEntity.getOwnerName()}), true);
            }
        }
        return InteractionResult.CONSUME;
    }
}

