/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.energy;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import earth.terrarium.pastel.blocks.energy.ColorPickerBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorPickerBlockEntityRenderer<T extends ColorPickerBlockEntity>
implements BlockEntityRenderer<T> {
    public ColorPickerBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ColorPickerBlockEntity blockEntity, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumerProvider, int light, int overlay) {
        Minecraft client = Minecraft.getInstance();
        ItemStack stack = blockEntity.getItem(0);
        ItemStack stack2 = blockEntity.getItem(1);
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.7, 0.6);
            poseStack.mulPose(Axis.XP.rotationDegrees(270.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, poseStack, vertexConsumerProvider, blockEntity.getLevel(), 0);
            poseStack.popPose();
        }
        if (!stack2.isEmpty()) {
            poseStack.pushPose();
            float time = (float)(blockEntity.getLevel().getGameTime() % 50000L) + tickDelta;
            double height = Math.sin((double)time / 8.0) / 6.0;
            poseStack.translate(0.5, 1.0 + height, 0.5);
            poseStack.mulPose(client.getBlockEntityRenderDispatcher().camera.rotation());
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(stack2, ItemDisplayContext.GROUND, light, overlay, poseStack, vertexConsumerProvider, blockEntity.getLevel(), 0);
            poseStack.popPose();
        }
    }
}

