/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.fluid;

import earth.terrarium.pastel.blocks.fluid.PastelFluid;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.recipe.fluid_converting.FluidConvertingRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelFluidTags;
import earth.terrarium.pastel.registries.PastelFluids;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class HumusFluid
extends PastelFluid {
    public Fluid getSource() {
        return (Fluid)PastelFluids.HUMUS.get();
    }

    public Fluid getFlowing() {
        return (Fluid)PastelFluids.FLOWING_HUMUS.get();
    }

    public Item getBucket() {
        return (Item)PastelItems.HUMUS_BUCKET.get();
    }

    public FluidType getFluidType() {
        return (FluidType)PastelFluids.HUMUS_TYPE.get();
    }

    protected BlockState createLegacyBlock(FluidState fluidState) {
        return (BlockState)((Block)PastelBlocks.HUMUS.get()).defaultBlockState().setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(HumusFluid.getLegacyLevel((FluidState)fluidState)));
    }

    @Override
    public boolean isSame(Fluid fluid) {
        return fluid == PastelFluids.HUMUS.get() || fluid == PastelFluids.FLOWING_HUMUS.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(Level world, BlockPos pos, FluidState state, RandomSource random) {
        BlockPos topPos = pos.above();
        BlockState topState = world.getBlockState(topPos);
        if (topState.isAir() && !topState.isSolidRender((BlockGetter)world, topPos) && random.nextInt(1000) == 0) {
            world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), PastelSounds.HUMUS_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }

    @Override
    protected int getSlopeFindDistance(LevelReader worldView) {
        return 1;
    }

    @Override
    protected int getDropOff(LevelReader worldView) {
        return 3;
    }

    @Override
    public int getTickDelay(LevelReader worldView) {
        return 50;
    }

    public ParticleOptions getDripParticle() {
        return PastelParticleTypes.DRIPPING_HUMUS;
    }

    @Override
    public ParticleOptions getSplashParticle() {
        return PastelParticleTypes.HUMUS_SPLASH;
    }

    @Override
    public RecipeType<? extends FluidConvertingRecipe> getDippingRecipeType() {
        return PastelRecipeTypes.HUMUS_CONVERTING;
    }

    @Override
    public void onEntityCollision(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.onEntityCollision(state, level, pos, entity);
        if (!level.isClientSide && entity instanceof LivingEntity) {
            MobEffectInstance slownessInstance;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.isEyeInFluid(PastelFluidTags.HUMUS) && level.getGameTime() % 2L == 0L && livingEntity.getAirSupply() > 0) {
                livingEntity.setAirSupply(livingEntity.getAirSupply() - 1);
            }
            if (level.getGameTime() % 20L == 0L && ((slownessInstance = livingEntity.getEffect(MobEffects.MOVEMENT_SLOWDOWN)) == null || slownessInstance.getDuration() < 20)) {
                MobEffectInstance newSlownessInstance = new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 3);
                livingEntity.addEffect(newSlownessInstance);
            }
        }
    }

    public static class StillHumus
    extends HumusFluid {
        public int getAmount(FluidState fluidState) {
            return 8;
        }

        public boolean isSource(FluidState fluidState) {
            return true;
        }
    }

    public static class FlowingHumus
    extends HumusFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState fluidState) {
            return (Integer)fluidState.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState fluidState) {
            return false;
        }
    }
}

