/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.fluid;

import earth.terrarium.pastel.api.block.MultiblockCrafter;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.recipe.fluid_converting.FluidConvertingRecipe;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PastelFluid
extends FlowingFluid {
    public boolean isSame(Fluid fluid) {
        return fluid == this.getSource() || fluid == this.getFlowing();
    }

    protected boolean canConvertToSource(Level world) {
        return false;
    }

    protected void beforeDestroyingBlock(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.hasBlockEntity() ? world.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    protected boolean canBeReplacedWith(FluidState fluidState, BlockGetter blockView, BlockPos blockPos, Fluid fluid, Direction direction) {
        return false;
    }

    protected int getSlopeFindDistance(LevelReader worldView) {
        return 3;
    }

    protected int getDropOff(LevelReader worldView) {
        return 1;
    }

    public int getTickDelay(LevelReader worldView) {
        return 20;
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.BUCKET_FILL);
    }

    public abstract ParticleOptions getSplashParticle();

    public void onEntityCollision(BlockState state, Level level, BlockPos pos, Entity entity) {
        ItemEntity itemEntity;
        if (!level.isClientSide && entity instanceof ItemEntity && !(itemEntity = (ItemEntity)entity).hasPickUpDelay() && !itemEntity.isRemoved() && level.random.nextInt(100) == 0) {
            ItemStack itemStack = itemEntity.getItem();
            FluidConvertingRecipe recipe = this.getConversionRecipeFor(this.getDippingRecipeType(), level, itemStack);
            if (recipe != null && !recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).is(itemStack.getItem())) {
                level.playSound(null, itemEntity.blockPosition(), SoundEvents.WOOL_BREAK, SoundSource.NEUTRAL, 1.0f, 0.9f + level.getRandom().nextFloat() * 0.2f);
                ItemStack result = this.assemble(recipe, itemStack, level);
                int count = result.getCount() * itemStack.getCount();
                result.setCount(count);
                Support.areaCriterion((ServerLevel)level, 8, pos, Optional.empty(), p -> PastelCriteria.FLUID_DIPPING.trigger((ServerPlayer)p, (ServerLevel)level, pos, itemStack, result));
                itemEntity.discard();
                MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(level, itemEntity.position(), result, count, Vec3.ZERO, false, itemEntity.getOwner());
            }
        }
    }

    public abstract RecipeType<? extends FluidConvertingRecipe> getDippingRecipeType();

    @Nullable
    public <R extends FluidConvertingRecipe> R getConversionRecipeFor(RecipeType<R> recipeType, @NotNull Level world, ItemStack itemStack) {
        RecipeHolder entry = world.getRecipeManager().getRecipeFor(recipeType, (RecipeInput)new SingleRecipeInput(itemStack), world).orElse(null);
        return (R)(entry == null ? null : (FluidConvertingRecipe)entry.value());
    }

    public ItemStack assemble(FluidConvertingRecipe recipe, ItemStack itemStack, Level world) {
        return recipe.assemble((RecipeInput)new SingleRecipeInput(itemStack), (HolderLookup.Provider)world.registryAccess());
    }
}

