/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.fusion_shrine;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import earth.terrarium.pastel.blocks.fusion_shrine.FusionShrineBlockEntity;
import earth.terrarium.pastel.render.FluidRendering;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.textures.FluidSpriteCache;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class FusionShrineBlockEntityRenderer<T extends FusionShrineBlockEntity>
implements BlockEntityRenderer<T> {
    public FusionShrineBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(FusionShrineBlockEntity shrine, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumerProvider, int light, int overlay) {
        FluidStack fluid = shrine.getTank().getFluid();
        if (!fluid.isEmpty()) {
            poseStack.pushPose();
            IClientFluidTypeExtensions renderData = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
            TextureAtlasSprite sprite = FluidSpriteCache.getSprite((ResourceLocation)renderData.getStillTexture(fluid));
            int[] colors = FluidRendering.unpackColor(renderData.getTintColor(fluid.getFluid().defaultFluidState(), (BlockAndTintGetter)shrine.getLevel(), shrine.getBlockPos()));
            FluidRendering.renderFluid(vertexConsumerProvider.getBuffer(RenderType.translucent()), poseStack.last().pose(), sprite, light, overlay, 2.0f, 14.0f, 0.9f, 2.0f, 14.0f, colors);
            poseStack.popPose();
        }
        if (!shrine.isEmpty()) {
            ArrayList<ItemStack> inventoryStacks = new ArrayList<ItemStack>();
            for (int i = 0; i < shrine.getContainerSize(); ++i) {
                ItemStack stack = shrine.getItem(i);
                if (stack.isEmpty()) continue;
                inventoryStacks.add(stack);
            }
            float time = (float)(shrine.getLevel().getGameTime() % 500000L) + tickDelta;
            double radiant = Math.toRadians((float)(360.0f / (float)inventoryStacks.size()));
            float distance = 1.2f;
            for (int i = 0; i < inventoryStacks.size(); ++i) {
                poseStack.pushPose();
                double currentRadiant = radiant * (double)i + radiant * ((double)time / 16.0) / (double)(8.0f / (float)inventoryStacks.size());
                double height = Math.sin((double)(((double)time + currentRadiant) / 8.0)) / 3.0;
                poseStack.translate((double)distance * Math.sin((double)currentRadiant) + 0.5, 1.5 + height, (double)distance * Math.cos((double)currentRadiant) + 0.5);
                poseStack.mulPose(Axis.YP.rotationDegrees(time * 2.0f));
                Minecraft.getInstance().getItemRenderer().renderStatic((ItemStack)inventoryStacks.get(i), ItemDisplayContext.GROUND, light, overlay, poseStack, vertexConsumerProvider, shrine.getLevel(), 0);
                poseStack.popPose();
            }
        }
    }
}

