/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AoEStatusEffectIdolBlock
extends IdolBlock {
    protected final int range;
    protected final Holder<MobEffect> statusEffect;
    protected final int amplifier;
    protected final int duration;

    public AoEStatusEffectIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect, Holder<MobEffect> statusEffect, int amplifier, int duration, int range) {
        super(settings, particleEffect);
        this.statusEffect = statusEffect;
        this.amplifier = amplifier;
        this.duration = duration;
        this.range = range;
    }

    public MapCodec<? extends AoEStatusEffectIdolBlock> codec() {
        return null;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.echolocating_idol.tooltip", (Object[])new Object[]{this.range}));
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        int boxSize = this.range + this.range;
        List livingEntities = world.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)blockPos), (double)boxSize, (double)boxSize, (double)boxSize));
        for (LivingEntity livingEntity : livingEntities) {
            livingEntity.addEffect(new MobEffectInstance(this.statusEffect, this.duration, this.amplifier));
        }
        return true;
    }
}

