/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class IdolBlock
extends Block {
    public static final BooleanProperty COOLDOWN = BooleanProperty.create((String)"cooldown");
    public final ParticleOptions particleEffect;

    public IdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect) {
        super(settings);
        this.particleEffect = particleEffect;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)COOLDOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COOLDOWN});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.mob_block.tooltip").withStyle(ChatFormatting.GRAY));
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            if (!this.hasCooldown(state) && this.trigger((ServerLevel)world, pos, state, (Entity)player, hit.getDirection())) {
                this.playTriggerParticles((ServerLevel)world, pos);
                this.playTriggerSound(world, pos);
                this.triggerCooldown(world, pos);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(state, world, pos, random);
        world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue((Property)COOLDOWN, (Comparable)Boolean.valueOf(false)));
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        super.stepOn(world, pos, state, entity);
        if (!world.isClientSide && !this.hasCooldown(state) && this.trigger((ServerLevel)world, pos, state, entity, Direction.UP)) {
            this.playTriggerParticles((ServerLevel)world, pos);
            this.playTriggerSound(world, pos);
            this.triggerCooldown(world, pos);
        }
    }

    public void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!world.isClientSide) {
            BlockPos hitPos = hit.getBlockPos();
            if (!this.hasCooldown(state) && this.trigger((ServerLevel)world, hitPos, state, projectile.getOwner(), hit.getDirection())) {
                this.playTriggerParticles((ServerLevel)world, hit.getBlockPos());
                this.playTriggerSound(world, hitPos);
                this.triggerCooldown(world, hitPos);
            }
        }
    }

    public abstract boolean trigger(ServerLevel var1, BlockPos var2, BlockState var3, @Nullable Entity var4, Direction var5);

    public void playTriggerParticles(ServerLevel world, BlockPos blockPos) {
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, new Vec3((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.2, (double)blockPos.getZ() + 0.5), this.particleEffect, 10, new Vec3(0.5, 0.5, 0.5), new Vec3(0.2, 0.08, 0.2));
    }

    public void playTriggerSound(Level world, BlockPos blockPos) {
        world.playSound(null, blockPos, this.soundType.getPlaceSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public boolean hasCooldown(BlockState state) {
        return (Boolean)state.getValue((Property)COOLDOWN);
    }

    public void triggerCooldown(Level world, BlockPos pos) {
        world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue((Property)COOLDOWN, (Comparable)Boolean.valueOf(true)));
        world.scheduleTick(pos, (Block)this, this.getCooldownTicks());
    }

    public int getCooldownTicks() {
        return 40;
    }

    public Vec3 getOutputLocation(BlockPos pos, Direction direction) {
        double d = (double)pos.getX() + 0.7 * (double)direction.getStepX();
        double e = (double)pos.getY() + 0.7 * (double)direction.getStepY();
        double f = (double)pos.getZ() + 0.7 * (double)direction.getStepZ();
        return new Vec3(d, e, f);
    }
}

