/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import earth.terrarium.pastel.entity.entity.EggLayingWoolyPigEntity;
import earth.terrarium.pastel.helpers.interaction.InWorldInteractionHelper;
import earth.terrarium.pastel.mixin.accessors.MooshroomEntityAccessor;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MilkingIdolBlock
extends IdolBlock {
    protected static final int BUCKET_SEARCH_RANGE = 7;
    protected final int milkingRange;

    public MilkingIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect, int milkingRange) {
        super(settings, particleEffect);
        this.milkingRange = milkingRange;
    }

    public MapCodec<? extends MilkingIdolBlock> codec() {
        return null;
    }

    @Override
    public boolean trigger(@NotNull ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        int boxSize = this.milkingRange + this.milkingRange;
        List goatEntities = world.getEntitiesOfClass(Goat.class, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)blockPos), (double)boxSize, (double)boxSize, (double)boxSize));
        for (Object goatEntity : goatEntities) {
            boolean emptyBucketFound;
            if (goatEntity.isBaby() || !(emptyBucketFound = InWorldInteractionHelper.findAndDecreaseClosestItemEntityOfItem(world, goatEntity.position(), Items.BUCKET, 7))) continue;
            SoundEvent soundEvent = goatEntity.isScreamingGoat() ? SoundEvents.GOAT_SCREAMING_MILK : SoundEvents.GOAT_MILK;
            world.playSound(null, goatEntity.blockPosition(), soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.spawnItemStackAtEntity(world, (LivingEntity)goatEntity, Items.MILK_BUCKET.getDefaultInstance());
        }
        List cowEntities = world.getEntitiesOfClass(Cow.class, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)blockPos), (double)boxSize, (double)boxSize, (double)boxSize));
        for (Cow cowEntity : cowEntities) {
            boolean emptyBucketFound;
            if (cowEntity.isBaby() || !(emptyBucketFound = InWorldInteractionHelper.findAndDecreaseClosestItemEntityOfItem(world, cowEntity.position(), Items.BUCKET, 7))) continue;
            world.playSound(null, cowEntity.blockPosition(), SoundEvents.COW_MILK, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.spawnItemStackAtEntity(world, (LivingEntity)cowEntity, Items.MILK_BUCKET.getDefaultInstance());
        }
        List eggLayingWoolyPigEntities = world.getEntitiesOfClass(EggLayingWoolyPigEntity.class, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)blockPos), (double)boxSize, (double)boxSize, (double)boxSize));
        for (EggLayingWoolyPigEntity eggLayingWoolyPigEntity : eggLayingWoolyPigEntities) {
            boolean emptyBucketFound;
            if (eggLayingWoolyPigEntity.isBaby() || !(emptyBucketFound = InWorldInteractionHelper.findAndDecreaseClosestItemEntityOfItem(world, eggLayingWoolyPigEntity.position(), Items.BUCKET, 7))) continue;
            world.playSound(null, eggLayingWoolyPigEntity.blockPosition(), SoundEvents.COW_MILK, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.spawnItemStackAtEntity(world, (LivingEntity)eggLayingWoolyPigEntity, Items.MILK_BUCKET.getDefaultInstance());
        }
        List mooshroomEntities = world.getEntitiesOfClass(MushroomCow.class, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)blockPos), (double)boxSize, (double)boxSize, (double)boxSize));
        for (MushroomCow mooshroomEntity : mooshroomEntities) {
            SoundEvent soundEvent;
            ItemStack resultStack;
            boolean emptyBowlFound;
            if (mooshroomEntity.isBaby() || !(emptyBowlFound = InWorldInteractionHelper.findAndDecreaseClosestItemEntityOfItem(world, mooshroomEntity.position(), Items.BOWL, 7))) continue;
            MooshroomEntityAccessor accessor = (MooshroomEntityAccessor)mooshroomEntity;
            if (accessor.getStewEffects() != null) {
                resultStack = new ItemStack((ItemLike)Items.SUSPICIOUS_STEW);
                resultStack.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)accessor.getStewEffects());
                accessor.setStewEffects(null);
                soundEvent = SoundEvents.MOOSHROOM_MILK_SUSPICIOUSLY;
            } else {
                resultStack = new ItemStack((ItemLike)Items.MUSHROOM_STEW);
                soundEvent = SoundEvents.MOOSHROOM_MILK;
            }
            world.playSound(null, mooshroomEntity.blockPosition(), soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.spawnItemStackAtEntity(world, (LivingEntity)mooshroomEntity, resultStack);
        }
        return true;
    }

    private void spawnItemStackAtEntity(ServerLevel world, @NotNull LivingEntity livingEntity, ItemStack itemStack) {
        ItemEntity itemEntity = new ItemEntity((Level)world, livingEntity.position().x(), livingEntity.position().y() + 0.5, livingEntity.position().z(), itemStack);
        itemEntity.push(0.0, (double)-0.2f, 0.0);
        world.addFreshEntity((Entity)itemEntity);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.milking_idol.tooltip", (Object[])new Object[]{this.milkingRange}));
        tooltip.add((Component)Component.translatable((String)"block.pastel.milking_idol.tooltip2"));
    }
}

