/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.item_bowl;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import earth.terrarium.pastel.blocks.item_bowl.ItemBowlBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemBowlBlockEntityRenderer
implements BlockEntityRenderer<ItemBowlBlockEntity> {
    final double radiant = Math.toRadians(360.0);

    public ItemBowlBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ItemBowlBlockEntity blockEntity, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumerProvider, int light, int overlay) {
        ItemStack stack = blockEntity.getItem(0);
        if (!stack.isEmpty()) {
            float time = (float)(blockEntity.getLevel().getGameTime() % 50000L) + tickDelta;
            poseStack.pushPose();
            double currentRadiant = this.radiant + this.radiant * ((double)time / 16.0) / 8.0;
            double height = Math.sin(((double)time + currentRadiant) / 8.0) / 7.0;
            poseStack.translate(0.5, 0.8 + height, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(time * 2.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, poseStack, vertexConsumerProvider, blockEntity.getLevel(), 0);
            poseStack.popPose();
        }
    }
}

