/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.item_roundel;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.InWorldInteractionBlock;
import earth.terrarium.pastel.blocks.item_roundel.ItemRoundelBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ItemRoundelBlock
extends InWorldInteractionBlock {
    public static final MapCodec<ItemRoundelBlock> CODEC = ItemRoundelBlock.simpleCodec(ItemRoundelBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);

    public ItemRoundelBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends ItemRoundelBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ItemRoundelBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ItemRoundelBlockEntity) {
            ItemRoundelBlockEntity itemRoundelBlockEntity = (ItemRoundelBlockEntity)blockEntity;
            if (player.isShiftKeyDown() || handStack.isEmpty()) {
                this.retrieveLastStack(world, pos, player, hand, handStack, itemRoundelBlockEntity);
            } else {
                this.inputHandStack(world, player, hand, handStack, itemRoundelBlockEntity);
            }
            blockEntity.setChanged();
            itemRoundelBlockEntity.updateInClientWorld();
        }
        return ItemInteractionResult.CONSUME;
    }
}

