/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.jade_vines;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.api.interaction.NaturesStaffTriggered;
import earth.terrarium.pastel.blocks.jade_vines.JadeVine;
import earth.terrarium.pastel.blocks.jade_vines.JadeVineRootsBlock;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class JadeVineBulbBlock
extends Block
implements JadeVine,
NaturesStaffTriggered {
    public static final MapCodec<JadeVineBulbBlock> CODEC = JadeVineBulbBlock.simpleCodec(JadeVineBulbBlock::new);
    public static final BooleanProperty DEAD = JadeVine.DEAD;

    public JadeVineBulbBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DEAD, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends JadeVineBulbBlock> codec() {
        return CODEC;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (!((Boolean)state.getValue((Property)DEAD)).booleanValue()) {
            JadeVine.spawnParticlesClient(world, pos);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return ((Item)PastelItems.GERMINATED_JADE_VINE_BULB.get()).getDefaultInstance();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return BULB_SHAPE;
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.above()).getBlock() instanceof JadeVineRootsBlock;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DEAD});
    }

    @Override
    public boolean setToAge(Level world, BlockPos blockPos, int age) {
        BlockState currentState = world.getBlockState(blockPos);
        boolean dead = (Boolean)currentState.getValue((Property)DEAD);
        if (age == 0 && !dead) {
            world.setBlockAndUpdate(blockPos, (BlockState)currentState.setValue((Property)DEAD, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        if (age > 0 && dead) {
            world.setBlockAndUpdate(blockPos, (BlockState)currentState.setValue((Property)DEAD, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        return false;
    }

    @Override
    public boolean canUseNaturesStaff(Level world, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)DEAD);
    }

    @Override
    public boolean onNaturesStaffUse(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos rootsPos = pos.above();
        BlockState rootsState = world.getBlockState(rootsPos);
        Block block = rootsState.getBlock();
        if (block instanceof JadeVineRootsBlock) {
            JadeVineRootsBlock jadeVineRootsBlock = (JadeVineRootsBlock)block;
            jadeVineRootsBlock.onNaturesStaffUse(world, rootsPos, rootsState, player);
        }
        JadeVine.spawnParticlesServer((ServerLevel)world, pos, 16);
        return false;
    }
}

