/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.jade_vines;

import earth.terrarium.pastel.helpers.interaction.TimeHelper;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeVineRootsBlockEntity
extends BlockEntity {
    private BlockState fenceBlockState = Blocks.OAK_FENCE.defaultBlockState();
    private long lastGrowthTick = -1L;
    private boolean wasExposedToSunlight = false;

    public JadeVineRootsBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.JADE_VINE_ROOTS.get(), pos, state);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ResourceLocation fenceBlockIdentifier;
        Block block;
        super.loadAdditional(nbt, registryLookup);
        if (nbt.contains("LastGrowthTick", 4)) {
            this.lastGrowthTick = nbt.getLong("LastGrowthTick");
        }
        if (nbt.contains("WasExposedToSunlight")) {
            this.wasExposedToSunlight = nbt.getBoolean("WasExposedToSunlight");
        }
        if (nbt.contains("FenceBlockIdentifier", 8) && (block = (Block)BuiltInRegistries.BLOCK.get(fenceBlockIdentifier = ResourceLocation.tryParse((String)nbt.getString("FenceBlockIdentifier")))) instanceof FenceBlock) {
            this.fenceBlockState = block.defaultBlockState();
        }
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putLong("LastGrowthTick", this.lastGrowthTick);
        nbt.putBoolean("WasExposedToSunlight", this.wasExposedToSunlight);
        if (this.fenceBlockState != null) {
            nbt.putString("FenceBlockIdentifier", BuiltInRegistries.BLOCK.getKey((Object)this.fenceBlockState.getBlock()).toString());
        }
    }

    public boolean isLaterNight(@NotNull Level world) {
        long dayTime = world.getDayTime();
        if (TimeHelper.getTimeOfDay(dayTime).isNight()) {
            return TimeHelper.getDay(dayTime + 1000L) != TimeHelper.getDay(this.lastGrowthTick + 1000L);
        }
        return false;
    }

    public long getLastGrownTime() {
        return this.lastGrowthTick;
    }

    public void setLastGrownTime(long time) {
        this.wasExposedToSunlight = false;
        this.lastGrowthTick = time;
        this.setChanged();
    }

    public BlockState getFenceBlockState() {
        return this.fenceBlockState;
    }

    public void setFenceBlockState(BlockState fenceBlockState) {
        this.fenceBlockState = fenceBlockState;
        this.setChanged();
        this.updateInClientWorld();
    }

    public boolean wasExposedToSunlight() {
        return this.wasExposedToSunlight;
    }

    public void setExposedToSunlight(boolean wasExposedToSunlight) {
        this.wasExposedToSunlight = wasExposedToSunlight;
        this.setChanged();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag nbtCompound = new CompoundTag();
        if (this.fenceBlockState != null) {
            nbtCompound.putString("FenceBlockIdentifier", BuiltInRegistries.BLOCK.getKey((Object)this.fenceBlockState.getBlock()).toString());
        }
        return nbtCompound;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void updateInClientWorld() {
        this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 4);
    }
}

