/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.jade_vines;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class NephriteBlossomLeavesBlock
extends LeavesBlock
implements BonemealableBlock {
    public static final MapCodec<NephriteBlossomLeavesBlock> CODEC = NephriteBlossomLeavesBlock.simpleCodec(NephriteBlossomLeavesBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;
    public static final int MAX_AGE = 2;

    public NephriteBlossomLeavesBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<? extends NephriteBlossomLeavesBlock> codec() {
        return CODEC;
    }

    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if ((Integer)state.getValue((Property)AGE) == 2) {
            int fortuneLevel = Ench.getLevel((HolderLookup.Provider)world.registryAccess(), (ResourceKey<Enchantment>)Enchantments.FORTUNE, handStack) / 2;
            int count = 1 + world.getRandom().nextInt(fortuneLevel + 1);
            player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)PastelItems.GLASS_PEACH.get(), count));
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
            player.playNotifySound(SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 1.0f + player.getRandom().nextFloat() * 0.25f);
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return super.useItemOn(handStack, state, world, pos, player, hand, hit);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        int leafSum = 0;
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue() || random.nextFloat() > 0.1f) {
            super.randomTick(state, world, pos, random);
            return;
        }
        for (BlockPos iPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
            BlockState leafState = world.getBlockState(iPos);
            if (!leafState.is((Block)this)) continue;
            leafSum += (((Integer)leafState.getValue((Property)AGE)).byteValue() + 1) * 3;
        }
        if (random.nextInt(leafSum = Math.max(leafSum, 0) + 1) != 0) {
            super.randomTick(state, world, pos, random);
        } else {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) != 2;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) != 2;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        Integer age = (Integer)state.getValue((Property)AGE);
        if (age == 2) {
            return;
        }
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
    }
}

