/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.memory;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.blocks.memory.MemoryItem;
import earth.terrarium.pastel.components.MemoryComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.helpers.level.EntityHelper;
import earth.terrarium.pastel.networking.s2c_payloads.PlayMemoryManifestingParticlesPayload;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryBlockEntity
extends BlockEntity
implements PlayerOwned {
    protected ItemStack memoryItemStack = ItemStack.EMPTY;
    protected UUID ownerUUID;
    private int tint1 = -1;
    private int tint2 = -1;

    public MemoryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.MEMORY.get(), pos, state);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Tuple<Integer, Integer> getEggColorsForEntity(EntityType<?> entityType) {
        SpawnEggItem spawnEggItem = SpawnEggItem.byId(entityType);
        if (spawnEggItem != null) {
            return new Tuple((Object)spawnEggItem.getColor(0), (Object)spawnEggItem.getColor(1));
        }
        return new Tuple((Object)0x222222, (Object)0xDDDDDD);
    }

    public static int getManifestAdvanceSteps(@NotNull Level world, @NotNull BlockPos blockPos) {
        BlockState belowBlockState = world.getBlockState(blockPos.below());
        if (belowBlockState.is(PastelBlockTags.MEMORY_NEVER_MANIFESTERS)) {
            return 0;
        }
        if (belowBlockState.is(PastelBlockTags.MEMORY_VERY_FAST_MANIFESTERS)) {
            return 8;
        }
        if (belowBlockState.is(PastelBlockTags.MEMORY_FAST_MANIFESTERS)) {
            return 3;
        }
        return 1;
    }

    public void setData(LivingEntity livingEntity, @NotNull ItemStack creatureSpawnItemStack) {
        Level level;
        if (livingEntity instanceof Player) {
            Player playerEntity = (Player)livingEntity;
            this.setOwner(playerEntity);
        }
        if (creatureSpawnItemStack.getItem() instanceof MemoryItem) {
            this.memoryItemStack = creatureSpawnItemStack.copy();
            this.memoryItemStack.setCount(1);
        }
        if (livingEntity != null && (level = livingEntity.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.getChunkSource().blockChanged(this.worldPosition);
        }
        this.setChanged();
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        if (nbt.contains("MemoryItem", 10)) {
            this.memoryItemStack = ItemStack.parseOptional((HolderLookup.Provider)registryLookup, (CompoundTag)nbt.getCompound("MemoryItem"));
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        if (this.memoryItemStack.isEmpty()) {
            CodecHelper.writeNbt(nbt, "MemoryItem", ItemStack.CODEC, this.memoryItemStack);
        }
    }

    public void advanceManifesting(ServerLevel world, BlockPos blockPos) {
        int additionalManifestAdvanceSteps;
        int ticksToManifest = MemoryItem.getTicksToManifest(this.memoryItemStack);
        if (ticksToManifest > 0 && (additionalManifestAdvanceSteps = MemoryBlockEntity.getManifestAdvanceSteps((Level)world, blockPos)) > 0) {
            int newTicksToManifest = ticksToManifest - additionalManifestAdvanceSteps;
            if (newTicksToManifest <= 0) {
                this.manifest(world, blockPos);
            } else {
                Optional<EntityType<?>> entityTypeOptional = MemoryItem.getEntityType(this.memoryItemStack);
                if (entityTypeOptional.isPresent()) {
                    MemoryItem.setTicksToManifest(this.memoryItemStack, newTicksToManifest);
                    PlayMemoryManifestingParticlesPayload.playMemoryManifestingParticles(world, blockPos, entityTypeOptional.get(), 3);
                    world.playSound(null, this.worldPosition, PastelSounds.BLOCK_MEMORY_ADVANCE, SoundSource.BLOCKS, 0.7f, 0.9f + world.random.nextFloat() * 0.2f);
                    this.setChanged();
                }
            }
        }
    }

    protected void manifest(@NotNull ServerLevel world, BlockPos blockPos) {
        MemoryBlockEntity.manifest(world, blockPos, this.memoryItemStack, this.ownerUUID);
    }

    public static boolean manifest(@NotNull ServerLevel level, BlockPos blockPos, ItemStack memoryItemStack, @Nullable UUID ownerUUID) {
        BlockState blockState = level.getBlockState(blockPos);
        if (blockState.getBlock() instanceof SimpleWaterloggedBlock && ((Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.setBlockAndUpdate(blockPos, Blocks.WATER.defaultBlockState());
        } else {
            level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
        }
        Optional<Entity> hatchedEntityOptional = MemoryBlockEntity.hatchEntity(level, blockPos, memoryItemStack);
        if (hatchedEntityOptional.isPresent()) {
            Entity hatchedEntity = hatchedEntityOptional.get();
            PlayMemoryManifestingParticlesPayload.playMemoryManifestingParticles(level, blockPos, hatchedEntity.getType(), 10);
            if (hatchedEntity instanceof Mob) {
                Mob hatchedMobEntity = (Mob)hatchedEntity;
                hatchedMobEntity.setPersistenceRequired();
                hatchedMobEntity.playAmbientSound();
                hatchedMobEntity.spawnAnim();
            }
            if (ownerUUID != null) {
                EntityHelper.addPlayerTrust(hatchedEntity, ownerUUID);
            }
            if (level instanceof ServerLevel) {
                ServerLevel sl = level;
                Support.areaCriterion(sl, 20, blockPos, PastelCommon.locate("unlocks/blocks/memories"), p -> PastelCriteria.MEMORY_MANIFESTING.trigger((ServerPlayer)p, hatchedEntity));
            }
            return true;
        }
        return false;
    }

    public int getEggColor(int tintIndex) {
        if (this.tint1 == -1) {
            if (this.memoryItemStack == null) {
                this.tint1 = 0x222222;
                this.tint2 = 0xDDDDDD;
            } else {
                this.tint1 = MemoryItem.getEggColor(this.memoryItemStack, 0);
                this.tint2 = MemoryItem.getEggColor(this.memoryItemStack, 1);
            }
        }
        if (tintIndex == 0) {
            return this.tint1;
        }
        return this.tint2;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag nbtCompound = new CompoundTag();
        this.saveAdditional(nbtCompound, registryLookup);
        return nbtCompound;
    }

    public static Optional<Entity> hatchEntity(ServerLevel world, BlockPos blockPos, ItemStack memoryItemStack) {
        return Optional.ofNullable((MemoryComponent)memoryItemStack.get(PastelDataComponentTypes.MEMORY)).flatMap(memory -> MemoryItem.getEntityType(memoryItemStack).map(entityType -> {
            Entity entity = entityType.spawn(world, memoryItemStack, null, blockPos, MobSpawnType.SPAWN_EGG, true, false);
            if (entity instanceof Mob) {
                Mob mobEntity = (Mob)entity;
                if (!memory.spawnAsAdult()) {
                    mobEntity.setBaby(true);
                }
            }
            return entity;
        }));
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(@NotNull Player playerEntity) {
        this.ownerUUID = playerEntity.getUUID();
        this.setChanged();
    }

    public ItemStack getMemoryItemStack() {
        return this.memoryItemStack;
    }
}

