/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.memory;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.components.MemoryComponent;
import earth.terrarium.pastel.recipe.spirit_instiller.SpiritInstillerRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryItem
extends BlockItem {
    private static final HashMap<EntityType<?>, Tuple<Integer, Integer>> customColors = new HashMap<EntityType<?>, Tuple<Integer, Integer>>(){
        {
            this.put(EntityType.BAT, new Tuple((Object)4603179, (Object)1643271));
            this.put(EntityType.SNOW_GOLEM, new Tuple((Object)13224911, (Object)10645032));
            this.put(EntityType.WITHER, new Tuple((Object)0x101211, (Object)4079936));
            this.put(EntityType.ILLUSIONER, new Tuple((Object)2709389, (Object)4935247));
            this.put(EntityType.ENDER_DRAGON, new Tuple((Object)0x111111, (Object)8744079));
            this.put(EntityType.IRON_GOLEM, new Tuple((Object)0x9A9A9A, (Object)9139300));
        }
    };

    public MemoryItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public static MemoryComponent getMemory(ItemStack stack) {
        return (MemoryComponent)stack.getOrDefault(PastelDataComponentTypes.MEMORY, (Object)MemoryComponent.DEFAULT);
    }

    public static ItemStack getMemoryForEntity(LivingEntity entity) {
        CompoundTag tag = new CompoundTag();
        entity.saveAsPassenger(tag);
        tag.remove("Pos");
        tag.remove("OnGround");
        tag.remove("Rotation");
        tag.remove("Motion");
        tag.remove("FallDistance");
        tag.remove("InLove");
        tag.remove("UUID");
        tag.remove("Health");
        tag.remove("Fire");
        tag.remove("HurtByTimestamp");
        tag.remove("DeathTime");
        tag.remove("AbsorptionAmount");
        tag.remove("Air");
        tag.remove("FallFlying");
        tag.remove("PortalCooldown");
        tag.remove("HurtTime");
        ItemStack stack = ((Block)PastelBlocks.MEMORY.get()).asItem().getDefaultInstance();
        stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
        return stack;
    }

    public static ItemStack getForEntityType(EntityType<?> entityType, int ticksToManifest) {
        ItemStack stack = ((Block)PastelBlocks.MEMORY.get()).asItem().getDefaultInstance();
        stack.set(PastelDataComponentTypes.MEMORY, (Object)new MemoryComponent.Builder(MemoryComponent.DEFAULT).ticksToManifest(ticksToManifest).build());
        CompoundTag entityCompound = new CompoundTag();
        entityCompound.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString());
        stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)entityCompound));
        return stack;
    }

    public static CompoundTag getEntityData(ItemStack stack) {
        return ((CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
    }

    public static Optional<EntityType<?>> getEntityType(ItemStack stack) {
        CompoundTag data = MemoryItem.getEntityData(stack);
        if (!data.contains("id", 8)) {
            return Optional.empty();
        }
        return EntityType.byString((String)data.getString("id"));
    }

    @Nullable
    public static Component getMemoryEntityCustomName(ItemStack stack, HolderLookup.Provider drm) {
        CompoundTag data = MemoryItem.getEntityData(stack);
        if (!data.contains("CustomName", 8)) {
            return null;
        }
        return Component.Serializer.fromJson((String)data.getString("CustomName"), (HolderLookup.Provider)drm);
    }

    public static int getTicksToManifest(ItemStack stack) {
        return MemoryItem.getMemory(stack).ticksToManifest();
    }

    public static void setTicksToManifest(@NotNull ItemStack itemStack, int newTicksToManifest) {
        itemStack.update(PastelDataComponentTypes.MEMORY, (Object)MemoryComponent.DEFAULT, comp -> new MemoryComponent.Builder((MemoryComponent)comp).ticksToManifest(newTicksToManifest).build());
    }

    public static void setSpawnAsAdult(@NotNull ItemStack itemStack, boolean spawnAsAdult) {
        itemStack.update(PastelDataComponentTypes.MEMORY, (Object)MemoryComponent.DEFAULT, comp -> new MemoryComponent.Builder((MemoryComponent)comp).spawnAsAdult(spawnAsAdult).build());
    }

    public static void markAsBrokenPromise(ItemStack itemStack, boolean isBrokenPromise) {
        itemStack.update(PastelDataComponentTypes.MEMORY, (Object)MemoryComponent.DEFAULT, comp -> new MemoryComponent.Builder((MemoryComponent)comp).brokenPromise(isBrokenPromise).build());
    }

    public static boolean isBrokenPromise(ItemStack stack) {
        return MemoryItem.getMemory(stack).brokenPromise();
    }

    public static boolean isUnrecognizable(ItemStack stack) {
        return MemoryItem.getMemory(stack).unrecognizable();
    }

    public static void makeUnrecognizable(@NotNull ItemStack itemStack) {
        itemStack.update(PastelDataComponentTypes.MEMORY, (Object)MemoryComponent.DEFAULT, comp -> new MemoryComponent.Builder((MemoryComponent)comp).unrecognizable().build());
    }

    public static int getEggColor(ItemStack stack, int tintIndex) {
        Optional<EntityType<?>> entityType;
        if (stack.has(PastelDataComponentTypes.MEMORY) && !MemoryItem.isUnrecognizable(stack) && (entityType = MemoryItem.getEntityType(stack)).isPresent()) {
            EntityType<?> type = entityType.get();
            if (customColors.containsKey(type)) {
                return tintIndex == 0 ? (Integer)customColors.get(type).getA() : (Integer)customColors.get(type).getB();
            }
            SpawnEggItem spawnEggItem = SpawnEggItem.byId(entityType.get());
            if (spawnEggItem != null) {
                return spawnEggItem.getColor(tintIndex);
            }
        }
        return tintIndex == 0 ? 0x222222 : 0xDDDDDD;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        MemoryItem.getEntityType(stack).ifPresentOrElse(entityType -> {
            if (MemoryItem.isUnrecognizable(stack)) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.memory.tooltip.unrecognizable_entity_type").withStyle(ChatFormatting.GRAY));
            } else {
                boolean isBrokenPromise = MemoryItem.isBrokenPromise(stack);
                Component customName = MemoryItem.getMemoryEntityCustomName(stack, context.registries());
                if (isBrokenPromise) {
                    if (customName == null) {
                        tooltip.add((Component)Component.translatable((String)"item.pastel.memory.tooltip.entity_type_broken_promise", (Object[])new Object[]{entityType.getDescription()}));
                    } else {
                        tooltip.add((Component)Component.translatable((String)"item.pastel.memory.tooltip.named_broken_promise").append(customName).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC}));
                    }
                } else if (customName == null) {
                    tooltip.add((Component)Component.translatable((String)"item.pastel.memory.tooltip.entity_type", (Object[])new Object[]{entityType.getDescription()}));
                } else {
                    tooltip.add((Component)Component.translatable((String)"item.pastel.memory.tooltip.named").append(customName).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC}));
                }
            }
            int ticksToHatch = MemoryItem.getTicksToManifest(stack);
            if (ticksToHatch <= 0) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.memory.tooltip.does_not_manifest").withStyle(ChatFormatting.GRAY));
            } else if (ticksToHatch > 100) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.memory.tooltip.extra_long_time_to_manifest").withStyle(ChatFormatting.GRAY));
            } else if (ticksToHatch > 20) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.memory.tooltip.long_time_to_manifest").withStyle(ChatFormatting.GRAY));
            } else if (ticksToHatch > 5) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.memory.tooltip.medium_time_to_manifest").withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.translatable((String)"item.pastel.memory.tooltip.short_time_to_manifest").withStyle(ChatFormatting.GRAY));
            }
        }, () -> tooltip.add((Component)Component.translatable((String)"item.pastel.memory.tooltip.unset_entity_type").withStyle(ChatFormatting.GRAY)));
    }

    public static void appendEntries(HolderLookup.Provider lookup, CreativeModeTab.Output entries) {
        HashSet<MemoryComponent> encountered = new HashSet<MemoryComponent>();
        if (PastelCommon.getSidedServer() != null) {
            Item memoryItem = ((Block)PastelBlocks.MEMORY.get()).asItem();
            for (RecipeHolder recipe : PastelCommon.getSidedServer().getRecipeManager().getAllRecipesFor(PastelRecipeTypes.SPIRIT_INSTILLING)) {
                ItemStack output = ((SpiritInstillerRecipe)recipe.value()).getResultItem(lookup);
                MemoryComponent memory = (MemoryComponent)output.get(PastelDataComponentTypes.MEMORY);
                if (!output.is(memoryItem) || memory == null || encountered.contains(memory)) continue;
                entries.accept(output);
                encountered.add(memory);
            }
        }
    }
}

