/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.mob_head;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.blocks.mob_head.PastelSkullType;
import earth.terrarium.pastel.blocks.mob_head.PastelWallSkullBlock;
import earth.terrarium.pastel.helpers.Support;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PastelSkullBlock
extends SkullBlock {
    public static final MapCodec<PastelSkullBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)PastelSkullType.CODEC.fieldOf("kind").forGetter(b -> b.skullType), (App)PastelSkullBlock.propertiesCodec()).apply((Applicative)i, PastelSkullBlock::new));
    public static final BiMap<PastelSkullType, Block> MOB_HEADS = EnumHashBiMap.create(PastelSkullType.class);
    private static final Map<Supplier<EntityType<?>>, PastelSkullType> ENTITY_TYPE_TO_SKULL_TYPE = new Object2ObjectOpenHashMap();
    private final PastelSkullType skullType;
    @Nullable
    private static BlockPattern witherBossPattern;

    public PastelSkullBlock(PastelSkullType skullType, BlockBehaviour.Properties settings) {
        super((SkullBlock.Type)skullType, settings);
        MOB_HEADS.put((Object)skullType, (Object)this);
        ENTITY_TYPE_TO_SKULL_TYPE.put(skullType.getEntityType(), skullType);
        this.skullType = skullType;
    }

    public MapCodec<? extends PastelSkullBlock> codec() {
        return CODEC;
    }

    public PastelSkullType getType() {
        return (PastelSkullType)super.getType();
    }

    public static Optional<EntityType<?>> getEntityTypeOfSkullStack(ItemStack itemStack) {
        SkullBlock skullBlock;
        BlockItem blockItem;
        Block block;
        Item item = itemStack.getItem();
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof SkullBlock && (block = (skullBlock = (SkullBlock)block).getType()) instanceof PastelSkullType) {
            PastelSkullType type = (PastelSkullType)block;
            return Optional.of(type.getEntityType().get());
        }
        if (Items.CREEPER_HEAD == item) {
            return Optional.of(EntityType.CREEPER);
        }
        if (Items.DRAGON_HEAD == item) {
            return Optional.of(EntityType.ENDER_DRAGON);
        }
        if (Items.ZOMBIE_HEAD == item) {
            return Optional.of(EntityType.ZOMBIE);
        }
        if (Items.SKELETON_SKULL == item) {
            return Optional.of(EntityType.SKELETON);
        }
        if (Items.WITHER_SKELETON_SKULL == item) {
            return Optional.of(EntityType.WITHER_SKELETON);
        }
        if (Items.PIGLIN_HEAD == item) {
            return Optional.of(EntityType.PIGLIN);
        }
        return Optional.empty();
    }

    public static Optional<Block> getBlock(SkullBlock.Type skullType) {
        if (skullType instanceof PastelSkullType) {
            PastelSkullType pastelSkullType = (PastelSkullType)skullType;
            return Optional.of((Block)MOB_HEADS.get((Object)pastelSkullType));
        }
        if (SkullBlock.Types.CREEPER == skullType) {
            return Optional.of(Blocks.CREEPER_HEAD);
        }
        if (SkullBlock.Types.DRAGON == skullType) {
            return Optional.of(Blocks.DRAGON_HEAD);
        }
        if (SkullBlock.Types.ZOMBIE == skullType) {
            return Optional.of(Blocks.ZOMBIE_HEAD);
        }
        if (SkullBlock.Types.SKELETON == skullType) {
            return Optional.of(Blocks.SKELETON_SKULL);
        }
        if (SkullBlock.Types.WITHER_SKELETON == skullType) {
            return Optional.of(Blocks.WITHER_SKELETON_SKULL);
        }
        if (SkullBlock.Types.PIGLIN == skullType) {
            return Optional.of(Blocks.PIGLIN_HEAD);
        }
        return Optional.empty();
    }

    public static Optional<SkullBlock.Type> getSkullType(EntityType<?> entityType) {
        if (EntityType.CREEPER == entityType) {
            return Optional.of(SkullBlock.Types.CREEPER);
        }
        if (EntityType.ENDER_DRAGON == entityType) {
            return Optional.of(SkullBlock.Types.DRAGON);
        }
        if (EntityType.ZOMBIE == entityType) {
            return Optional.of(SkullBlock.Types.ZOMBIE);
        }
        if (EntityType.SKELETON == entityType) {
            return Optional.of(SkullBlock.Types.SKELETON);
        }
        if (EntityType.WITHER_SKELETON == entityType) {
            return Optional.of(SkullBlock.Types.WITHER_SKELETON);
        }
        if (EntityType.PIGLIN == entityType) {
            return Optional.of(SkullBlock.Types.PIGLIN);
        }
        return Optional.ofNullable((SkullBlock.Type)ENTITY_TYPE_TO_SKULL_TYPE.get(entityType));
    }

    @Contract(pure=true)
    @NotNull
    public static Collection<Block> getMobHeads() {
        return MOB_HEADS.values();
    }

    private static BlockPattern getWitherSkullPattern() {
        if (witherBossPattern == null) {
            PastelSkullBlock.getBlock(PastelSkullType.WITHER).ifPresent(b -> {
                witherBossPattern = BlockPatternBuilder.start().aisle(new String[]{"^^^", "###", "~#~"}).where('#', pos -> pos.getState().is(BlockTags.WITHER_SUMMON_BASE_BLOCKS)).where('^', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)b).or((Predicate)BlockStatePredicate.forBlock((Block)PastelWallSkullBlock.getMobWallHead(PastelSkullType.WITHER))))).where('~', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.AIR))).build();
            });
        }
        return witherBossPattern;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SkullBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return null;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (this.getType().equals((Object)PastelSkullType.WITHER) && placer instanceof ServerPlayer) {
            BlockPattern blockPattern;
            BlockPattern.BlockPatternMatch result;
            ServerPlayer serverPlayerEntity = (ServerPlayer)placer;
            if (pos.getY() >= world.getMinBuildHeight() && (result = (blockPattern = PastelSkullBlock.getWitherSkullPattern()).find((LevelReader)world, pos)) != null) {
                Support.grantAdvancementCriterion(serverPlayerEntity, "midgame/build_wither_using_wither_heads", "built_wither_using_wither_heads");
            }
        }
    }
}

