/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.mob_head;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.blocks.mob_head.PastelSkullType;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PastelWallSkullBlock
extends WallSkullBlock {
    public static final MapCodec<PastelWallSkullBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)PastelSkullType.CODEC.fieldOf("kind").forGetter(b -> b.skullType), (App)PastelWallSkullBlock.propertiesCodec()).apply((Applicative)i, PastelWallSkullBlock::new));
    public static BiMap<PastelSkullType, Block> MOB_WALL_HEADS = EnumHashBiMap.create(PastelSkullType.class);
    private final PastelSkullType skullType;

    public PastelWallSkullBlock(PastelSkullType skullType, BlockBehaviour.Properties settings) {
        super((SkullBlock.Type)skullType, settings);
        this.skullType = skullType;
        MOB_WALL_HEADS.put((Object)skullType, (Object)this);
    }

    public MapCodec<? extends PastelWallSkullBlock> codec() {
        return CODEC;
    }

    public static Block getMobWallHead(PastelSkullType skullType) {
        return (Block)MOB_WALL_HEADS.get((Object)skullType);
    }

    @Contract(pure=true)
    @NotNull
    public static Collection<Block> getMobWallHeads() {
        return MOB_WALL_HEADS.values();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SkullBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return null;
    }
}

