/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pastel_network;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.pastel.PastelCommon;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class PastelRenderHelper {
    public static final ResourceLocation BEAM_TEXTURE_ID = PastelCommon.locate("textures/entity/pastel_line.png");
    public static final float BEAM_WIDTH = 0.05f;

    public static void renderLineTo(PoseStack matrices, MultiBufferSource vertexConsumers, float[] color, BlockPos thisPos, BlockPos pos) {
        Minecraft client = Minecraft.getInstance();
        matrices.pushPose();
        Vec3 vec = Vec3.atCenterOf((Vec3i)pos);
        Vec3 here = Vec3.atCenterOf((Vec3i)thisPos);
        Vec3 delta = vec.subtract(here);
        float dist = (float)vec.length();
        Vec3 axis = delta.scale((double)(-1.0f / dist));
        Camera camera = client.gameRenderer.getMainCamera();
        double[] billBoard = PastelRenderHelper.billboard(vec.x * 1.0, vec.y * 1.0, vec.z * 1.0, camera.getPosition().x, camera.getPosition().y, camera.getPosition().z, axis.x, axis.y, axis.z);
        PoseStack.Pose entry = matrices.last();
        Matrix4f model = entry.pose();
        VertexConsumer buffer = vertexConsumers.getBuffer(RenderType.beaconBeam((ResourceLocation)BEAM_TEXTURE_ID, (boolean)true));
        PastelRenderHelper.renderBeamFace(billBoard, model, entry, buffer, color[1], color[2], color[3], color[0], dist, 0.0f, 0.0f, 0.05f, -0.05f, 0.0f, 0.5f, 0.0f, 1.0f);
        PastelRenderHelper.renderBeamFace(billBoard, model, entry, buffer, color[1], color[2], color[3], color[0], dist, -0.05f, -0.05f, 0.0f, 0.0f, 0.5f, 1.0f, 0.0f, 1.0f);
        matrices.popPose();
    }

    private static void renderBeamFace(double[] mat, Matrix4f positionMatrix, PoseStack.Pose entry, VertexConsumer vertices, float red, float green, float blue, float alpha, float length, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        PastelRenderHelper.renderBeamVertex(mat, positionMatrix, entry, vertices, red, green, blue, alpha, x1, length, z1, u2, v1);
        PastelRenderHelper.renderBeamVertex(mat, positionMatrix, entry, vertices, red, green, blue, alpha, x1, 0.0f, z1, u2, v2);
        PastelRenderHelper.renderBeamVertex(mat, positionMatrix, entry, vertices, red, green, blue, alpha, x2, 0.0f, z2, u1, v2);
        PastelRenderHelper.renderBeamVertex(mat, positionMatrix, entry, vertices, red, green, blue, alpha, x2, length, z2, u1, v1);
    }

    private static void renderBeamVertex(double[] mat, Matrix4f positionMatrix, PoseStack.Pose entry, VertexConsumer vertices, float red, float green, float blue, float alpha, float x, float y, float z, float u, float v) {
        Vec3 transform = PastelRenderHelper.transform(new Vec3((double)x, (double)y, (double)z), mat);
        vertices.addVertex(positionMatrix, (float)transform.x, (float)transform.y, (float)transform.z).setColor(red, green, blue, alpha).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(entry, 0.0f, 1.0f, 0.0f);
    }

    private static Vec3 transform(Vec3 vec, double[] mat) {
        double x = mat[PastelRenderHelper.matIndex(0, 0)] * vec.x + mat[PastelRenderHelper.matIndex(0, 1)] * vec.y + mat[PastelRenderHelper.matIndex(0, 2)] * vec.z + mat[PastelRenderHelper.matIndex(0, 3)];
        double y = mat[PastelRenderHelper.matIndex(1, 0)] * vec.x + mat[PastelRenderHelper.matIndex(1, 1)] * vec.y + mat[PastelRenderHelper.matIndex(1, 2)] * vec.z + mat[PastelRenderHelper.matIndex(1, 3)];
        double z = mat[PastelRenderHelper.matIndex(2, 0)] * vec.x + mat[PastelRenderHelper.matIndex(2, 1)] * vec.y + mat[PastelRenderHelper.matIndex(2, 2)] * vec.z + mat[PastelRenderHelper.matIndex(2, 3)];
        return new Vec3(x, y, z);
    }

    private static double[] billboard(double objX, double objY, double objZ, double targetX, double targetY, double targetZ, double upX, double upY, double upZ) {
        double dirX = targetX - objX;
        double dirY = targetY - objY;
        double dirZ = targetZ - objZ;
        double leftX = upY * dirZ - upZ * dirY;
        double leftY = upZ * dirX - upX * dirZ;
        double leftZ = upX * dirY - upY * dirX;
        double invLeftLen = 1.0 / Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        dirX = (leftY *= invLeftLen) * upZ - (leftZ *= invLeftLen) * upY;
        dirY = leftZ * upX - (leftX *= invLeftLen) * upZ;
        dirZ = leftX * upY - leftY * upX;
        double invDirLen = 1.0 / Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        dirX *= invDirLen;
        dirY *= invDirLen;
        dirZ *= invDirLen;
        double[] mat = new double[16];
        mat[PastelRenderHelper.matIndex((int)0, (int)0)] = leftX;
        mat[PastelRenderHelper.matIndex((int)1, (int)0)] = leftY;
        mat[PastelRenderHelper.matIndex((int)2, (int)0)] = leftZ;
        mat[PastelRenderHelper.matIndex((int)3, (int)0)] = 0.0;
        mat[PastelRenderHelper.matIndex((int)0, (int)1)] = upX;
        mat[PastelRenderHelper.matIndex((int)1, (int)1)] = upY;
        mat[PastelRenderHelper.matIndex((int)2, (int)1)] = upZ;
        mat[PastelRenderHelper.matIndex((int)3, (int)1)] = 0.0;
        mat[PastelRenderHelper.matIndex((int)0, (int)2)] = dirX;
        mat[PastelRenderHelper.matIndex((int)1, (int)2)] = dirY;
        mat[PastelRenderHelper.matIndex((int)2, (int)2)] = dirZ;
        mat[PastelRenderHelper.matIndex((int)3, (int)2)] = 0.0;
        mat[PastelRenderHelper.matIndex((int)0, (int)3)] = objX;
        mat[PastelRenderHelper.matIndex((int)1, (int)3)] = objY;
        mat[PastelRenderHelper.matIndex((int)2, (int)3)] = objZ;
        mat[PastelRenderHelper.matIndex((int)3, (int)3)] = 1.0;
        return mat;
    }

    private static int matIndex(int x, int y) {
        return x * 4 + y;
    }

    public static float[] unpackNormalizedColor(int color) {
        float[] colors = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return colors;
    }
}

