/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pastel_network.network;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import earth.terrarium.pastel.blocks.pastel_network.network.NodeRemovalReason;
import earth.terrarium.pastel.blocks.pastel_network.network.PastelNetwork;
import earth.terrarium.pastel.blocks.pastel_network.network.PastelNetworkManager;
import earth.terrarium.pastel.blocks.pastel_network.network.PastelTransmission;
import earth.terrarium.pastel.blocks.pastel_network.network.ServerPastelNetwork;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.networking.s2c_payloads.PastelNetworkRemovedPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class ServerPastelNetworkManager
extends SavedData
implements PastelNetworkManager<ServerLevel, ServerPastelNetwork> {
    private static final String PERSISTENT_STATE_ID = "pastel_pastel_network_manager";
    private final List<ServerPastelNetwork> networks = new ArrayList<ServerPastelNetwork>();

    public boolean isDirty() {
        return true;
    }

    public static ServerPastelNetworkManager get(ServerLevel world) {
        SavedData.Factory type = new SavedData.Factory(ServerPastelNetworkManager::new, (nbtCompound, lookup) -> ServerPastelNetworkManager.fromNbt(nbtCompound), null);
        return (ServerPastelNetworkManager)world.getDataStorage().computeIfAbsent(type, PERSISTENT_STATE_ID);
    }

    public ServerPastelNetwork createNetwork(ServerLevel world, PastelNodeBlockEntity initialNode) {
        ServerPastelNetwork network = new ServerPastelNetwork(world, initialNode);
        this.networks.add(network);
        initialNode.setNetworkUUID(network.getUUID());
        return network;
    }

    public void connectNodes(PastelNodeBlockEntity child, PastelNodeBlockEntity parent) {
        Optional<ServerPastelNetwork> parentNetwork = parent.getServerNetwork();
        Optional<ServerPastelNetwork> childNetwork = child.getServerNetwork();
        if (childNetwork.isEmpty() && parentNetwork.isEmpty()) {
            parentNetwork = Optional.of(this.createNetwork((ServerLevel)parent.getLevel(), parent));
        }
        if (childNetwork.isEmpty()) {
            ServerPastelNetworkManager.addAndSync(child, parent);
            return;
        }
        if (parentNetwork.isEmpty()) {
            ServerPastelNetworkManager.addAndSync(parent, child);
            return;
        }
        if (childNetwork.get() != parentNetwork.get()) {
            if (parentNetwork.get().size() > childNetwork.get().size()) {
                parentNetwork.get().incorporate(childNetwork.get(), child, parent);
            } else {
                childNetwork.get().incorporate(parentNetwork.get(), child, parent);
            }
        }
        throw new IllegalStateException("Tried to merge a Pastel Network with itself");
    }

    private static void addAndSync(PastelNodeBlockEntity newNode, PastelNodeBlockEntity reference) {
        assert (reference.getServerNetwork().isPresent());
        ServerPastelNetwork parentNetwork = reference.getServerNetwork().get();
        parentNetwork.addNodeAndConnect(newNode, reference);
        parentNetwork.markDirty(reference.getBlockPos());
    }

    @Override
    public ServerPastelNetwork createNetwork(ServerLevel world, UUID uuid, int color) {
        ServerPastelNetwork network = new ServerPastelNetwork(world, uuid, color);
        this.networks.add(network);
        return network;
    }

    @Override
    public Optional<ServerPastelNetwork> getNetwork(UUID uuid) {
        return this.networks.stream().filter(n -> n.uuid.equals(uuid)).findFirst();
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ListTag networkList = new ListTag();
        for (ServerPastelNetwork network : this.networks) {
            Optional opt = ServerPastelNetwork.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)network).result();
            if (!opt.isPresent()) continue;
            CompoundTag wrapper = new CompoundTag();
            wrapper.put("network", (Tag)opt.get());
            wrapper.put("graph", (Tag)network.graphToNbt());
            wrapper.put("scheduler", (Tag)ServerPastelNetworkManager.transgender(network.getTransmissions()));
            networkList.add((Object)wrapper);
        }
        nbt.put("Networks", (Tag)networkList);
        return nbt;
    }

    public static ServerPastelNetworkManager fromNbt(CompoundTag nbt) {
        ServerPastelNetworkManager manager = new ServerPastelNetworkManager();
        for (Tag element : nbt.getList("Networks", 10)) {
            CompoundTag comp = (CompoundTag)element;
            Tag netNbt = comp.get("network");
            CompoundTag graphNbt = comp.getCompound("graph");
            CompoundTag schedulerNbt = comp.getCompound("scheduler");
            Optional<ServerPastelNetwork> network = CodecHelper.fromNbt(ServerPastelNetwork.CODEC, netNbt);
            if (!network.isPresent()) continue;
            network.get().setGraph(PastelNetwork.graphFromNbt(graphNbt));
            network.get().getTransmissions().putAll(ServerPastelNetworkManager.transDecode(schedulerNbt, network.get()));
            manager.networks.add(network.get());
        }
        return manager;
    }

    @NotNull
    private static HashMap<PastelTransmission, Integer> transDecode(CompoundTag schedulerNbt, ServerPastelNetwork network) {
        ListTag transmissions = schedulerNbt.getList("transmissions", 10);
        int[] timers = schedulerNbt.getIntArray("timers");
        HashMap<PastelTransmission, Integer> map = new HashMap<PastelTransmission, Integer>();
        for (int i = 0; i < transmissions.size(); ++i) {
            Optional result = PastelTransmission.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)transmissions.get(i)).result();
            if (result.isEmpty()) continue;
            PastelTransmission trans = (PastelTransmission)((Pair)result.get()).getFirst();
            trans.setNetwork(network);
            map.put(trans, timers[i]);
        }
        return map;
    }

    public void tick() {
        for (int i = 0; i < this.networks.size(); ++i) {
            this.networks.get(i).tick();
        }
    }

    private static CompoundTag transgender(Map<PastelTransmission, Integer> trans) {
        CompoundTag transNbt = new CompoundTag();
        ListTag transmissions = new ListTag();
        int[] timers = new int[trans.size()];
        for (Map.Entry<PastelTransmission, Integer> transmissionEntry : trans.entrySet()) {
            Optional result = PastelTransmission.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)transmissionEntry.getKey()).result();
            if (!result.isPresent()) continue;
            transmissions.add((Object)((Tag)result.get()));
            timers[transmissions.size() - 1] = transmissionEntry.getValue();
        }
        transNbt.put("transmissions", (Tag)transmissions);
        transNbt.putIntArray("timers", timers);
        return transNbt;
    }

    @Override
    public void removeNetwork(UUID uuid) {
        ServerPastelNetwork foundNetwork = null;
        for (ServerPastelNetwork network : this.networks) {
            if (!network.uuid.equals(uuid)) continue;
            foundNetwork = network;
            break;
        }
        if (foundNetwork != null) {
            this.networks.remove(foundNetwork);
            PastelNetworkRemovedPayload.send(foundNetwork);
        }
    }

    public void removeNode(PastelNodeBlockEntity node, NodeRemovalReason reason) {
        Optional<ServerPastelNetwork> optional = node.getServerNetwork();
        if (optional.isPresent()) {
            ServerPastelNetwork network = optional.get();
            if (network.size() == 1) {
                this.removeNetwork(network.getUUID());
            } else {
                network.removeNode(node, reason);
            }
        }
    }
}

