/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pastel_network.nodes;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.pastel.PastelUpgradeSignature;
import earth.terrarium.pastel.blocks.pastel_network.Pastel;
import earth.terrarium.pastel.blocks.pastel_network.network.PastelNetwork;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeBlock;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeType;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import earth.terrarium.pastel.helpers.render.RenderHelper;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class PastelNodeBlockEntityRenderer
implements BlockEntityRenderer<PastelNodeBlockEntity> {
    private static final long REAL_DAY_LENGTH = 1728000L;
    private static final Crystal CONNECTION = new Crystal(((Item)PastelItems.CONNECTION_NODE_CRYSTAL.get()).getDefaultInstance(), 0.25, false);
    private static final Crystal PROVIDER = new Crystal(((Item)PastelItems.PROVIDER_NODE_CRYSTAL.get()).getDefaultInstance(), 0.1, true);
    private static final Crystal SENDER = new Crystal(((Item)PastelItems.SENDER_NODE_CRYSTAL.get()).getDefaultInstance(), 0.1, true);
    private static final Crystal STORAGE = new Crystal(((Item)PastelItems.STORAGE_NODE_CRYSTAL.get()).getDefaultInstance(), 0.15, true);
    private static final Crystal BUFFER = new Crystal(((Item)PastelItems.BUFFER_NODE_CRYSTAL.get()).getDefaultInstance(), 0.1, true);
    private static final Crystal GATHER = new Crystal(((Item)PastelItems.GATHER_NODE_CRYSTAL.get()).getDefaultInstance(), 0.1, false);
    private static final ResourceLocation BASE = PastelCommon.locate("textures/block/pastel_node_base.png");
    private static final ResourceLocation INNER_RING = PastelCommon.locate("textures/block/pastel_node_inner_ring_blank.png");
    private static final ResourceLocation OUTER_RING = PastelCommon.locate("textures/block/pastel_node_outer_ring_blank.png");
    private static final ResourceLocation REDSTONE_RING = PastelCommon.locate("textures/block/pastel_node_redstone_ring_blank.png");
    private final ModelPart base = PastelNodeBlockEntityRenderer.getItemNodeBaseTexturedModelData().bakeRoot();

    public PastelNodeBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    @NotNull
    public static LayerDefinition getItemNodeBaseTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("base", CubeListBuilder.create().texOffs(6, 0).addBox(-1.0f, 1.1f, -1.0f, 2.0f, 0.0f, 2.0f), PartPose.ZERO);
        modelPartData.addOrReplaceChild("leaf1", CubeListBuilder.create().texOffs(-4, 0).addBox(-2.0f, 1.0f, -4.0f, 4.0f, 0.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        modelPartData.addOrReplaceChild("leaf2", CubeListBuilder.create().texOffs(-4, 4).addBox(-2.0f, 1.0f, 0.0f, 4.0f, 0.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        modelPartData.addOrReplaceChild("leaf3", CubeListBuilder.create().texOffs(-4, 8).addBox(0.0f, 1.0f, -2.0f, 4.0f, 0.0f, 4.0f), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        modelPartData.addOrReplaceChild("leaf4", CubeListBuilder.create().texOffs(-4, 12).addBox(-4.0f, 1.0f, -2.0f, 4.0f, 0.0f, 4.0f), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)16, (int)16);
    }

    public void render(PastelNodeBlockEntity node, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (node.getState() == null) {
            return;
        }
        Level world = node.getLevel();
        if (world == null) {
            return;
        }
        float time = (float)((world.getGameTime() + node.getCreationStamp()) % 1728000L) + tickDelta;
        Crystal crystal = switch (node.getNodeType()) {
            default -> throw new MatchException(null, null);
            case PastelNodeType.CONNECTION -> CONNECTION;
            case PastelNodeType.STORAGE -> STORAGE;
            case PastelNodeType.BUFFER -> BUFFER;
            case PastelNodeType.PROVIDER -> PROVIDER;
            case PastelNodeType.SENDER -> SENDER;
            case PastelNodeType.GATHER -> GATHER;
        };
        boolean minimal = PastelCommon.CONFIG.MinimalNodes;
        float heightMod = minimal ? 0.7f : 0.5f;
        switch (node.getState()) {
            case CONNECTED: {
                node.rotationTarget = this.mod((double)time / (Math.PI * 3));
                node.heightTarget = (float)Math.sin(time / 19.0f) / 10.0f + heightMod;
                node.alphaTarget = 1.0f;
                break;
            }
            case DISCONNECTED: {
                node.heightTarget = 0.0f;
                node.alphaTarget = 0.0f;
                break;
            }
            case ACTIVE: {
                node.rotationTarget = this.mod((double)time / Math.PI);
                node.heightTarget = (float)Math.sin(time / 19.0f) / 10.0f + heightMod;
                node.alphaTarget = 1.0f;
                break;
            }
            case INACTIVE: {
                node.rotationTarget = this.mod((double)time / (Math.PI * 7));
                node.heightTarget = (float)Math.sin(time / 19.0f) / 20.0f + heightMod / 2.0f;
                node.alphaTarget = 0.275f;
            }
        }
        float interp = Mth.clamp((float)(((float)node.interpTicks + tickDelta) / (float)node.interpLength), (float)0.0f, (float)1.0f);
        node.crystalRotation = Mth.lerp((float)interp, (float)node.lastRotationTarget, (float)node.rotationTarget);
        node.crystalHeight = Mth.lerp((float)interp, (float)node.lastHeightTarget, (float)node.heightTarget);
        node.ringAlpha = Mth.lerp((float)interp, (float)node.lastAlphaTarget, (float)node.alphaTarget);
        Direction facing = (Direction)node.getBlockState().getValue((Property)PastelNodeBlock.FACING);
        matrices.pushPose();
        matrices.translate(0.5, 0.5, 0.5);
        switch (facing) {
            case DOWN: {
                matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
                break;
            }
            case NORTH: {
                matrices.mulPose(Axis.XP.rotationDegrees(270.0f));
                break;
            }
            case SOUTH: {
                matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
                matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                matrices.mulPose(Axis.YP.rotationDegrees(270.0f));
                matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
        }
        matrices.translate(0.0, -0.5, 0.0);
        if (minimal) {
            float quarterCrystalRotation = node.crystalRotation / 2.0f;
            matrices.mulPose(Axis.YP.rotation(quarterCrystalRotation));
            VertexConsumer rootBuffer = vertexConsumers.getBuffer(RenderType.entityCutout((ResourceLocation)BASE));
            this.base.render(matrices, rootBuffer, light, overlay);
            matrices.mulPose(Axis.YP.rotation(quarterCrystalRotation * 2.0f));
            matrices.scale(0.6f, 0.6f, 0.6f);
        } else {
            matrices.mulPose(Axis.YP.rotation(node.crystalRotation));
        }
        Vector3f color = ColorHelper.colorIntToVec(node.networkUUID.flatMap(id -> Pastel.getClientInstance().getNetwork((UUID)id)).map(PastelNetwork::getColor).orElse(0xFFFFFF));
        color = ColorHelper.colorIntToVec(ColorHelper.interpolate(color, ColorHelper.WASH, 0.2125f));
        float ringHeight = node.crystalHeight - 0.3f;
        VertexConsumer innerRing = vertexConsumers.getBuffer(RenderType.entityTranslucent((ResourceLocation)node.getInnerRing().map(PastelUpgradeSignature::innerRing).orElse(INNER_RING)));
        if (node.getInnerRing().isPresent()) {
            RenderHelper.renderFlatTransWithZYOffset(matrices, innerRing, true, 3.75f + ringHeight / 2.0f, 7.0f, node.ringAlpha, 1.0f, overlay);
        } else {
            RenderHelper.renderFlatTransWithZYOffsetAndColor(matrices, innerRing, true, 3.75f + ringHeight / 2.0f, 7.0f, node.ringAlpha, 1.0f, overlay, color.x, color.y, color.z);
        }
        VertexConsumer redstoneRing = vertexConsumers.getBuffer(RenderType.entityTranslucent((ResourceLocation)node.getRedstoneRing().map(PastelUpgradeSignature::outerRing).orElse(REDSTONE_RING)));
        if (node.getRedstoneRing().isPresent()) {
            RenderHelper.renderFlatTransWithZYOffset(matrices, redstoneRing, true, 5.0f + ringHeight, 15.0f, node.ringAlpha * node.getRedstoneAlphaMult(), 1.0f, overlay);
        } else {
            RenderHelper.renderFlatTransWithZYOffsetAndColor(matrices, redstoneRing, true, 5.0f + ringHeight, 15.0f, node.ringAlpha * node.getRedstoneAlphaMult(), 1.0f, overlay, color.x, color.y, color.z);
        }
        if (crystal.hasOuterRing()) {
            VertexConsumer outerRing = vertexConsumers.getBuffer(RenderType.entityTranslucent((ResourceLocation)node.getOuterRing().map(PastelUpgradeSignature::outerRing).orElse(OUTER_RING)));
            if (node.getOuterRing().isPresent()) {
                RenderHelper.renderFlatTransWithZYOffset(matrices, outerRing, true, 5.75f + ringHeight * 2.0f, 11.0f, node.ringAlpha, 1.0f, overlay);
            } else {
                RenderHelper.renderFlatTransWithZYOffsetAndColor(matrices, outerRing, true, 5.75f + ringHeight * 2.0f, 11.0f, node.ringAlpha, 1.0f, overlay, color.x, color.y, color.z);
            }
        }
        matrices.translate(0.0, (double)node.crystalHeight + crystal.yOffset, 0.0);
        Minecraft.getInstance().getItemRenderer().renderStatic(crystal.crystal, ItemDisplayContext.NONE, 0xF000F0, overlay, matrices, vertexConsumers, node.getLevel(), 0);
        matrices.popPose();
    }

    private float mod(double in) {
        return (float)(in % (Math.PI * 2));
    }

    private record Crystal(ItemStack crystal, double yOffset, boolean hasOuterRing) {
    }
}

