/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pedestal;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.block.PaintbrushTriggered;
import earth.terrarium.pastel.api.block.PedestalVariant;
import earth.terrarium.pastel.api.block.RedstonePoweredBlock;
import earth.terrarium.pastel.blocks.InWorldInteractionBlock;
import earth.terrarium.pastel.blocks.pedestal.PedestalBlockEntity;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconHelper;
import earth.terrarium.pastel.networking.s2c_payloads.PlayPedestalStartCraftingParticlePayload;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelMultiblocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PedestalBlock
extends BaseEntityBlock
implements RedstonePoweredBlock,
PaintbrushTriggered {
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("place_pedestal");
    private static final VoxelShape SHAPE;
    private final PedestalVariant variant;

    public PedestalBlock(BlockBehaviour.Properties settings, PedestalVariant variant) {
        super(settings);
        this.variant = variant;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends PedestalBlock> codec() {
        return null;
    }

    public static void upgradeTo(@NotNull Level world, BlockPos blockPos, BlockState old, PedestalVariant upgrade) {
        world.setBlockAndUpdate(blockPos, (BlockState)upgrade.getPedestalBlock().defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)((Boolean)old.getValue((Property)BlockStateProperties.POWERED))));
    }

    public static void clearCurrentlyRenderedMultiBlock(Level world) {
        if (world.isClientSide) {
            ModonomiconHelper.clearRenderedMultiblock(PastelMultiblocks.get(PastelMultiblocks.PEDESTAL_SIMPLE));
            ModonomiconHelper.clearRenderedMultiblock(PastelMultiblocks.get(PastelMultiblocks.PEDESTAL_ADVANCED));
            ModonomiconHelper.clearRenderedMultiblock(PastelMultiblocks.get(PastelMultiblocks.PEDESTAL_COMPLEX));
            ModonomiconHelper.clearRenderedMultiblock(PastelMultiblocks.get(PastelMultiblocks.PEDESTAL_COMPLEX_WITHOUT_MOONSTONE));
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (placer instanceof ServerPlayer && (blockEntity = world.getBlockEntity(pos)) instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestalBlockEntity = (PedestalBlockEntity)blockEntity;
            pedestalBlockEntity.setOwner((Player)((ServerPlayer)placer));
            blockEntity.setChanged();
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{BlockStateProperties.POWERED});
    }

    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemInteractionResult actionResult = this.checkAndDoPaintbrushTrigger(state, level, pos, player, hand, hit);
        if (actionResult.consumesAction()) {
            return actionResult;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        level.getBlockEntity(pos, (BlockEntityType)PastelBlockEntities.PEDESTAL.get()).ifPresent(p -> p.giveStoredXp(player));
        this.openScreen(level, pos, player);
        return ItemInteractionResult.CONSUME;
    }

    protected void openScreen(Level world, BlockPos pos, Player player) {
        Optional blockEntity = world.getBlockEntity(pos, (BlockEntityType)PastelBlockEntities.PEDESTAL.get());
        if (blockEntity.isPresent()) {
            PedestalBlockEntity pedestalBlockEntity = (PedestalBlockEntity)blockEntity.get();
            pedestalBlockEntity.setOwner(player);
            player.openMenu((MenuProvider)pedestalBlockEntity);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        Block block = newState.getBlock();
        if (block instanceof PedestalBlock) {
            BlockEntity blockEntity;
            PedestalBlock newPed = (PedestalBlock)block;
            if (!state.is((Block)newPed) && (blockEntity = world.getBlockEntity(pos)) instanceof PedestalBlockEntity) {
                PedestalBlockEntity pedestal = (PedestalBlockEntity)blockEntity;
                pedestal.refreshVariant();
            }
        } else {
            InWorldInteractionBlock.scatterContents(world, pos);
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PedestalBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, @NotNull Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level world, BlockState state, BlockEntityType<T> type) {
        return PedestalBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PastelBlockEntities.PEDESTAL.get()), (BlockEntityTicker)(world.isClientSide ? PedestalBlockEntity::clientTick : PedestalBlockEntity::serverTick));
    }

    public void neighborChanged(BlockState state, @NotNull Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (!world.isClientSide) {
            if (this.checkGettingPowered(world, pos)) {
                this.power(world, pos);
            } else {
                this.unPower(world, pos);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(@NotNull BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
            Vector3f color = new Vector3f(0.6f, 0.33f, 0.1f);
            float xOffset = random.nextFloat();
            float zOffset = random.nextFloat();
            world.addParticle((ParticleOptions)new DustParticleOptions(color, 1.0f), (double)((float)pos.getX() + xOffset), (double)(pos.getY() + 1), (double)((float)pos.getZ() + zOffset), 0.0, 0.0, 0.0);
        }
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world.isClientSide()) {
            PedestalBlock.clearCurrentlyRenderedMultiBlock((Level)world);
        }
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        BlockState placementState = this.defaultBlockState();
        if (ctx.getLevel().getBestNeighborSignal(ctx.getClickedPos()) > 0) {
            placementState = (BlockState)placementState.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true));
        }
        return placementState;
    }

    public PedestalVariant getVariant() {
        return this.variant;
    }

    @Override
    public ItemInteractionResult onPaintBrushTrigger(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Optional be = level.getBlockEntity(pos, (BlockEntityType)PastelBlockEntities.PEDESTAL.get());
        if (be.isEmpty()) {
            return ItemInteractionResult.FAIL;
        }
        PedestalBlockEntity pedestal = (PedestalBlockEntity)be.get();
        if (pedestal.active || pedestal.craftingTime <= 0) {
            return ItemInteractionResult.FAIL;
        }
        if (!level.isClientSide) {
            pedestal.setActive(true);
            PlayPedestalStartCraftingParticlePayload.spawnPedestalStartCraftingParticles(pedestal);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    static {
        VoxelShape foot = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);
        VoxelShape neck = Block.box((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0);
        VoxelShape head = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        foot = Shapes.or((VoxelShape)foot, (VoxelShape)neck);
        SHAPE = Shapes.or((VoxelShape)foot, (VoxelShape)head);
    }
}

