/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.present;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.api.item.PresentUnpackBehavior;
import earth.terrarium.pastel.blocks.present.PresentBlockEntity;
import earth.terrarium.pastel.blocks.present.PresentBlockItem;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithExactVelocityPayload;
import earth.terrarium.pastel.networking.s2c_payloads.PlayPresentOpeningParticlesPayload;
import earth.terrarium.pastel.particle.effect.DynamicParticleEffect;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PresentBlock
extends BaseEntityBlock {
    public static final MapCodec<PresentBlock> CODEC = PresentBlock.simpleCodec(PresentBlock::new);
    protected static Map<ResourceLocation, PresentUnpackBehavior> BEHAVIORS = new Object2ObjectOpenHashMap();
    public static final int TICKS_PER_OPENING_STEP = 20;
    public static final int OPENING_STEPS = 6;
    public static final BooleanProperty OPENING = BooleanProperty.create((String)"opening");
    public static final EnumProperty<WrappingPaper> VARIANT = EnumProperty.create((String)"variant", WrappingPaper.class);
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);

    @Nullable
    public PresentUnpackBehavior getBehaviorFor(ItemStack stack) {
        return BEHAVIORS.getOrDefault(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), null);
    }

    public static void registerBehavior(ResourceLocation provider, PresentUnpackBehavior behavior) {
        BEHAVIORS.put(provider, behavior);
    }

    public PresentBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)OPENING, (Comparable)Boolean.valueOf(false))).setValue(VARIANT, (Comparable)((Object)WrappingPaper.RED)));
    }

    public MapCodec<? extends PresentBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{OPENING, VARIANT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader world, BlockPos pos) {
        BlockState downState = world.getBlockState(pos.below());
        return downState.isFaceSturdy((BlockGetter)world, pos, Direction.UP);
    }

    public void setPlacedBy(@NotNull Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        world.setBlockAndUpdate(pos, (BlockState)state.setValue(VARIANT, (Comparable)((Object)PresentBlockItem.getWrapData(itemStack).variant())));
        if (blockEntity instanceof PresentBlockEntity) {
            PresentBlockEntity presentBlockEntity = (PresentBlockEntity)blockEntity;
            presentBlockEntity.setPresent(itemStack);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof PresentBlockEntity) {
            PresentBlockEntity presentBlockEntity = (PresentBlockEntity)blockEntity;
            if (player.isShiftKeyDown()) {
                presentBlockEntity.setOpenerUUID(player);
                state = (BlockState)state.setValue((Property)OPENING, (Comparable)Boolean.valueOf(true));
                world.setBlock(pos, state, 3);
                world.scheduleTick(pos, state.getBlock(), 20);
            } else if (presentBlockEntity.getOwnerName() != null) {
                player.displayClientMessage((Component)Component.translatable((String)"block.pastel.present.tooltip.wrapped_placed.giver", (Object[])new Object[]{presentBlockEntity.getOwnerName()}), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"block.pastel.present.tooltip.wrapped_placed"), true);
            }
        }
        return InteractionResult.CONSUME;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof PresentBlockEntity) {
            PresentBlockEntity presentBlockEntity = (PresentBlockEntity)blockEntity;
            return List.of(presentBlockEntity.retrievePresent());
        }
        return super.getDrops(state, builder);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)OPENING)).booleanValue() && !world.isClientSide) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof PresentBlockEntity) {
                PresentBlockEntity presentBlockEntity = (PresentBlockEntity)blockEntity;
                int openingTick = presentBlockEntity.openingTick();
                Vec3 posVec = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5);
                if (openingTick >= 6) {
                    PresentBlock.spawnParticles((Level)world, pos, presentBlockEntity.getColors());
                    presentBlockEntity.triggerAdvancement();
                    if (presentBlockEntity.isEmpty()) {
                        world.playSound(null, posVec.x, posVec.y, posVec.z, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 0.8f);
                        PlayParticleWithExactVelocityPayload.playParticleWithExactVelocity(world, posVec, (ParticleOptions)ParticleTypes.SMOKE, 5, Vec3.ZERO);
                    } else {
                        world.playSound(null, posVec.x, posVec.y, posVec.z, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 0.5f, 4.0f);
                        PlayParticleWithExactVelocityPayload.playParticleWithExactVelocity(world, posVec, (ParticleOptions)ParticleTypes.EXPLOSION, 1, Vec3.ZERO);
                        for (ItemStack stack : presentBlockEntity.getStacks()) {
                            @Nullable PresentUnpackBehavior behavior = this.getBehaviorFor(stack);
                            if (behavior != null && !(stack = behavior.onPresentUnpack(stack, presentBlockEntity, world, pos, random)).isEmpty()) continue;
                            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
                        }
                    }
                    world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                } else {
                    world.playSound(null, posVec.x, posVec.y, posVec.z, SoundEvents.SAND_PLACE, SoundSource.BLOCKS, 0.8f + (float)openingTick * 0.1f, 1.0f);
                    PresentBlock.spawnParticles((Level)world, pos, presentBlockEntity.getColors());
                }
            }
            world.scheduleTick(pos, state.getBlock(), 20);
        }
    }

    public static void spawnParticles(Level level, BlockPos pos, Map<Integer, Integer> colors) {
        if (!level.isClientSide()) {
            PlayPresentOpeningParticlesPayload.playPresentOpeningParticles((ServerLevel)level, pos, colors);
            return;
        }
        if (colors.isEmpty()) {
            int randomColor = DyeColor.byId((int)level.random.nextInt(DyeColor.values().length)).getTextureDiffuseColor();
            PresentBlock.spawnParticles(level, pos, randomColor, 15);
        } else {
            for (Map.Entry<Integer, Integer> color : colors.entrySet()) {
                PresentBlock.spawnParticles(level, pos, color.getKey(), color.getValue() * 10);
            }
        }
    }

    private static void spawnParticles(Level world, BlockPos pos, int color, int amount) {
        double posX = (double)pos.getX() + 0.5;
        double posY = (double)pos.getY() + 0.25;
        double posZ = (double)pos.getZ() + 0.5;
        RandomSource random = world.random;
        Vector3f colorVec = ColorHelper.colorIntToVec(color);
        for (int i = 0; i < amount; ++i) {
            double randX = 0.35 - (double)random.nextFloat() * 0.7;
            double randY = (double)random.nextFloat() * 0.7;
            double randZ = 0.35 - (double)random.nextFloat() * 0.7;
            float randomScale = 0.5f + random.nextFloat();
            int randomLifetime = 20 + random.nextInt(20);
            DynamicParticleEffect particleEffect = new DynamicParticleEffect(0.98f, colorVec, randomScale, randomLifetime, true, false);
            world.addParticle((ParticleOptions)particleEffect, posX, posY, posZ, randX, randY, randZ);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PresentBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public static enum WrappingPaper implements StringRepresentable
    {
        RED(Blocks.RED_WOOL),
        BLUE(Blocks.BLUE_WOOL),
        CYAN(Blocks.CYAN_WOOL),
        GREEN(Blocks.GREEN_WOOL),
        PURPLE(Blocks.PURPLE_WOOL),
        CAKE(Blocks.LIGHT_GRAY_WOOL),
        STRIPED(Blocks.GREEN_WOOL),
        STARRY(Blocks.PURPLE_WOOL),
        WINTER(Blocks.LIGHT_GRAY_WOOL),
        PRIDE(Blocks.ORANGE_WOOL);

        public final Block woolBase;

        private WrappingPaper(Block woolBase) {
            this.woolBase = woolBase;
        }

        public String getSerializedName() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

