/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.present;

import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.api.block.PlayerOwnedWithName;
import earth.terrarium.pastel.blocks.present.PresentBlockItem;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PresentBlockEntity
extends BlockEntity
implements PlayerOwnedWithName {
    protected ItemStack presentStack = ItemStack.EMPTY;
    private UUID openerUUID;
    protected int openingTicks = 0;

    public PresentBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.PRESENT.get(), pos, state);
    }

    public void triggerAdvancement() {
        Player wrapper;
        UUID ownerUUID;
        Player opener;
        UUID openerUUID = this.getOpenerUUID();
        if (openerUUID != null && (opener = PlayerOwned.getPlayerEntityIfOnline(openerUUID)) != null) {
            Support.grantAdvancementCriterion((ServerPlayer)opener, "gift_or_open_present", "gifted_or_opened_present");
        }
        if ((ownerUUID = this.getOwnerUUID()) != null && (wrapper = PlayerOwned.getPlayerEntityIfOnline(ownerUUID)) != null) {
            Support.grantAdvancementCriterion((ServerPlayer)wrapper, "gift_or_open_present", "gifted_or_opened_present");
        }
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.presentStack = ItemStack.parseOptional((HolderLookup.Provider)registryLookup, (CompoundTag)nbt.getCompound("Present"));
        this.openerUUID = nbt.contains("OpenerUUID") ? nbt.getUUID("OpenerUUID") : null;
        if (nbt.contains("OpeningTick", 99)) {
            this.openingTicks = nbt.getInt("OpeningTick");
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.put("Present", this.presentStack.saveOptional(registryLookup));
        if (this.openerUUID != null) {
            nbt.putUUID("OpenerUUID", this.openerUUID);
        }
        if (this.openingTicks > 0) {
            nbt.putInt("OpeningTick", this.openingTicks);
        }
    }

    public int openingTick() {
        ++this.openingTicks;
        this.setChanged();
        return this.openingTicks;
    }

    @Override
    public UUID getOwnerUUID() {
        return PresentBlockItem.getOwner(this.presentStack).flatMap(ResolvableProfile::id).orElse(null);
    }

    public ResolvableProfile getOwner() {
        return PresentBlockItem.getOwner(this.presentStack).orElse(null);
    }

    @Override
    public String getOwnerName() {
        return PresentBlockItem.getOwner(this.presentStack).flatMap(ResolvableProfile::name).orElse("???");
    }

    @Override
    public void setOwner(Player playerEntity) {
        PresentBlockItem.setOwner(this.presentStack, playerEntity);
        this.setChanged();
    }

    public void setOpenerUUID(Player opener) {
        this.openerUUID = opener.getUUID();
        this.setChanged();
    }

    public UUID getOpenerUUID() {
        return this.openerUUID;
    }

    public ItemStack retrievePresent() {
        return this.presentStack.copy();
    }

    public Map<Integer, Integer> getColors() {
        return PresentBlockItem.getWrapData(this.presentStack).colors();
    }

    public List<ItemStack> getStacks() {
        return PresentBlockItem.getBundledStacks(this.presentStack).toList();
    }

    public void setPresent(ItemStack present) {
        this.presentStack = present;
        this.setChanged();
    }

    public boolean isEmpty() {
        return PresentBlockItem.isEmpty(this.presentStack);
    }
}

