/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.redstone.BlockBreakerBlockEntity;
import earth.terrarium.pastel.blocks.redstone.RedstoneInteractionBlock;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BlockBreakerBlock
extends RedstoneInteractionBlock
implements EntityBlock {
    public static final MapCodec<BlockBreakerBlock> CODEC = BlockBreakerBlock.simpleCodec(BlockBreakerBlock::new);
    private static ItemStack BREAK_STACK;

    public BlockBreakerBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends BlockBreakerBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockBreakerBlockEntity(pos, state);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (placer instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)placer;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof BlockBreakerBlockEntity) {
                BlockBreakerBlockEntity blockBreakerBlockEntity = (BlockBreakerBlockEntity)blockEntity;
                blockBreakerBlockEntity.setOwner((Player)serverPlayerEntity);
            }
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean isTriggered = world.hasNeighborSignal(pos) || world.hasNeighborSignal(pos.above());
        boolean wasTriggered = (Boolean)state.getValue((Property)TRIGGERED);
        if (isTriggered && !wasTriggered) {
            if (!world.isClientSide) {
                this.destroy(world, pos, ((FrontAndTop)state.getValue((Property)ORIENTATION)).front());
            }
            world.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!isTriggered && wasTriggered) {
            world.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    protected void destroy(Level world, BlockPos breakerPos, Direction direction) {
        BlockPos breakingPos = breakerPos.relative(direction);
        BlockState blockState = world.getBlockState(breakingPos);
        if (blockState.isAir() || blockState.getBlock() instanceof BaseFireBlock) {
            return;
        }
        float hardness = blockState.getDestroySpeed((BlockGetter)world, breakingPos);
        if (hardness < 0.0f || hardness > 50.0f) {
            world.playSound(null, breakerPos, PastelSounds.REDSTONE_MECHANISM_BREAK_BLOCK, SoundSource.BLOCKS, 0.15f, 2.0f + world.random.nextFloat());
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(breakerPos);
        if (!(blockEntity instanceof BlockBreakerBlockEntity)) {
            return;
        }
        BlockBreakerBlockEntity blockBreakerBlockEntity = (BlockBreakerBlockEntity)blockEntity;
        Player owner = blockBreakerBlockEntity.getOwnerIfOnline();
        if (!GenericClaimModsCompat.canBreak(world, breakingPos, (Entity)owner)) {
            return;
        }
        this.breakBlock(world, breakingPos, owner);
        Vec3 centerPos = Vec3.atCenterOf((Vec3i)breakingPos);
        ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, centerPos.x(), centerPos.y(), centerPos.z(), 1, 0.0, 0.0, 0.0, 1.0);
    }

    public void breakBlock(Level world, BlockPos pos, Player breaker) {
        BlockEntity blockEntity;
        BlockState blockState = world.getBlockState(pos);
        FluidState fluidState = world.getFluidState(pos);
        world.levelEvent(2001, pos, Block.getId((BlockState)blockState));
        world.playSound(null, pos, blockState.getSoundType().getBreakSound(), SoundSource.BLOCKS, 0.2f, (1.0f + world.random.nextFloat()) * 2.0f);
        BlockEntity blockEntity2 = blockEntity = blockState.hasBlockEntity() ? world.getBlockEntity(pos) : null;
        if (BREAK_STACK == null) {
            BREAK_STACK = new ItemStack((ItemLike)PastelItems.MALACHITE_WORKSTAFF.get());
        }
        Block.dropResources((BlockState)blockState, (Level)world, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)breaker, (ItemStack)BREAK_STACK);
        if (world.setBlock(pos, fluidState.createLegacyBlock(), 3, 512)) {
            world.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((Entity)breaker, (BlockState)blockState));
        }
    }
}

