/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockBreakerBlockEntity
extends BlockEntity
implements PlayerOwned {
    private UUID ownerUUID;

    public BlockBreakerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.BLOCK_BREAKER.get(), pos, state);
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(Player playerEntity) {
        this.ownerUUID = playerEntity.getUUID();
        this.setChanged();
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
    }
}

