/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class DetectorBlock
extends Block {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty INVERTED = BlockStateProperties.INVERTED;
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    protected static final double DETECTION_DIAMETER = 20.0;

    public DetectorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.mayBuild()) {
            if (world.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            BlockState blockState = (BlockState)state.cycle((Property)INVERTED);
            world.setBlock(pos, blockState, 4);
            this.updateState(blockState, world, pos);
            return InteractionResult.CONSUME;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWER, INVERTED});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return (Integer)state.getValue((Property)POWER);
    }

    @Deprecated
    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        this.updateState(state, world, pos);
        world.scheduleTick(pos, state.getBlock(), this.getUpdateFrequencyTicks());
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.updateState(state, (Level)world, pos);
        world.scheduleTick(pos, state.getBlock(), this.getUpdateFrequencyTicks());
    }

    abstract void updateState(BlockState var1, Level var2, BlockPos var3);

    abstract int getUpdateFrequencyTicks();

    protected AABB getDetectionBox(BlockPos pos) {
        return AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)pos), (double)20.0, (double)20.0, (double)20.0);
    }
}

