/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EnderGlassBlock
extends Block {
    public static final MapCodec<EnderGlassBlock> CODEC = EnderGlassBlock.simpleCodec(EnderGlassBlock::new);
    public static final EnumProperty<TransparencyState> TRANSPARENCY_STATE = EnumProperty.create((String)"transparency_state", TransparencyState.class);

    public EnderGlassBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(TRANSPARENCY_STATE, (Comparable)((Object)TransparencyState.SOLID)));
    }

    public MapCodec<? extends EnderGlassBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{TRANSPARENCY_STATE});
    }

    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        return state.getValue(TRANSPARENCY_STATE) != TransparencyState.SOLID && stateFrom.is((Block)this) || super.skipRendering(state, stateFrom, direction);
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        switch (((TransparencyState)((Object)state.getValue(TRANSPARENCY_STATE))).ordinal()) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                return 0.5f;
            }
        }
        return 1.0f;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return state.getValue(TRANSPARENCY_STATE) == TransparencyState.NO_COLLISION;
    }

    @Deprecated
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.getValue(TRANSPARENCY_STATE) == TransparencyState.NO_COLLISION) {
            return Shapes.empty();
        }
        return state.getShape(world, pos);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return state.getValue(TRANSPARENCY_STATE) != TransparencyState.SOLID;
    }

    public int getLightBlock(BlockState state, BlockGetter world, BlockPos pos) {
        if (state.getValue(TRANSPARENCY_STATE) == TransparencyState.SOLID) {
            return world.getMaxLightLevel();
        }
        return super.getLightBlock(state, world, pos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.getValue(TRANSPARENCY_STATE) == TransparencyState.NO_COLLISION) {
            return Shapes.block();
        }
        return super.getShape(state, world, pos, context);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        int power = ctx.getLevel().getBestNeighborSignal(ctx.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue(TRANSPARENCY_STATE, (Comparable)((Object)this.getStateForRedstonePower(power)));
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (!world.isClientSide) {
            BlockState fromPosBlockState = world.getBlockState(fromPos);
            if (fromPosBlockState.getBlock() instanceof EnderGlassBlock) {
                TransparencyState sourceTransparencyState = (TransparencyState)((Object)fromPosBlockState.getValue(TRANSPARENCY_STATE));
                if (sourceTransparencyState != state.getValue(TRANSPARENCY_STATE)) {
                    world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue(TRANSPARENCY_STATE, (Comparable)((Object)sourceTransparencyState)));
                }
            } else if (fromPosBlockState.isAir() || fromPosBlockState.isSignalSource()) {
                this.setTransparencyStateBasedOnRedstone(world, pos, state);
            }
        }
        super.neighborChanged(state, world, pos, block, fromPos, notify);
    }

    private void setTransparencyStateBasedOnRedstone(Level world, BlockPos blockPos, BlockState currentState) {
        int powerAtPos = world.getBestNeighborSignal(blockPos);
        TransparencyState targetTransparencyState = this.getStateForRedstonePower(powerAtPos);
        if (currentState.getValue(TRANSPARENCY_STATE) != targetTransparencyState) {
            world.setBlockAndUpdate(blockPos, (BlockState)currentState.setValue(TRANSPARENCY_STATE, (Comparable)((Object)targetTransparencyState)));
        }
    }

    private TransparencyState getStateForRedstonePower(int power) {
        if (power == 15) {
            return TransparencyState.NO_COLLISION;
        }
        if (power == 0) {
            return TransparencyState.SOLID;
        }
        return TransparencyState.TRANSLUCENT;
    }

    public static enum TransparencyState implements StringRepresentable
    {
        SOLID("solid"),
        TRANSLUCENT("translucent"),
        NO_COLLISION("no_collision");

        private final String name;

        private TransparencyState(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

