/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.NotNull;

public class RedstoneTimerBlock
extends DiodeBlock {
    public static final MapCodec<RedstoneTimerBlock> CODEC = RedstoneTimerBlock.simpleCodec(RedstoneTimerBlock::new);
    public static final EnumProperty<TimingStep> ACTIVE_TIME = EnumProperty.create((String)"active_time", TimingStep.class);
    public static final EnumProperty<TimingStep> INACTIVE_TIME = EnumProperty.create((String)"inactive_time", TimingStep.class);

    public RedstoneTimerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(ACTIVE_TIME, (Comparable)((Object)TimingStep.ONE_SECOND))).setValue(INACTIVE_TIME, (Comparable)((Object)TimingStep.ONE_SECOND)));
    }

    public MapCodec<? extends RedstoneTimerBlock> codec() {
        return CODEC;
    }

    protected int getDelay(BlockState state) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return ((TimingStep)((Object)state.getValue(RedstoneTimerBlock.ACTIVE_TIME))).ticks;
        }
        return ((TimingStep)((Object)state.getValue(RedstoneTimerBlock.INACTIVE_TIME))).ticks;
    }

    public InteractionResult useWithoutItem(BlockState state, @NotNull Level world, BlockPos pos, @NotNull Player player, BlockHitResult hit) {
        if (!player.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.stepTiming((ServerLevel)world, pos, (ServerPlayer)player);
        return InteractionResult.CONSUME;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, ACTIVE_TIME, INACTIVE_TIME});
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.onPlace(state, world, pos, oldState, notify);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.getBlockTicks().clearArea(new BoundingBox(pos));
            serverWorld.scheduleTick(pos, state.getBlock(), this.getDelay(state));
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockState newState = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)POWERED) == false));
        world.setBlock(pos, newState, 3);
        world.playSound(null, pos, PastelSounds.REDSTONE_MECHANISM_TRIGGER, SoundSource.BLOCKS, 0.3f, 1.0f);
        world.scheduleTick(pos, (Block)this, this.getDelay(state), TickPriority.NORMAL);
    }

    protected int getInputSignal(Level world, BlockPos pos, BlockState state) {
        return (Boolean)world.getBlockState(pos).getValue((Property)POWERED) != false ? 15 : 0;
    }

    protected void checkTickOnNeighbor(Level world, BlockPos pos, BlockState state) {
        boolean bl = (Boolean)state.getValue((Property)POWERED);
        if (!world.getBlockTicks().willTickThisTick(pos, (Object)this)) {
            TickPriority tickPriority = TickPriority.HIGH;
            if (this.shouldPrioritize((BlockGetter)world, pos, state)) {
                tickPriority = TickPriority.EXTREMELY_HIGH;
            } else if (bl) {
                tickPriority = TickPriority.VERY_HIGH;
            }
            world.scheduleTick(pos, (Block)this, this.getDelay(state), tickPriority);
        }
    }

    public void stepTiming(ServerLevel world, BlockPos pos, ServerPlayer serverPlayerEntity) {
        if (serverPlayerEntity != null) {
            BlockState blockState = world.getBlockState(pos);
            if (serverPlayerEntity.isShiftKeyDown()) {
                newStep = ((TimingStep)((Object)blockState.getValue(INACTIVE_TIME))).next();
                serverPlayerEntity.displayClientMessage((Component)Component.translatable((String)"block.pastel.redstone_timer.setting.inactive").append((Component)Component.translatable((String)newStep.localizationString)), true);
                float pitch = 0.5f + (float)newStep.ordinal() * 0.05f;
                world.playSound(null, pos, PastelSounds.REDSTONE_MECHANISM_TRIGGER, SoundSource.BLOCKS, 0.3f, pitch);
                world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue(INACTIVE_TIME, (Comparable)((Object)newStep)));
            } else {
                newStep = ((TimingStep)((Object)blockState.getValue(ACTIVE_TIME))).next();
                serverPlayerEntity.displayClientMessage((Component)Component.translatable((String)"block.pastel.redstone_timer.setting.active").append((Component)Component.translatable((String)newStep.localizationString)), true);
                float pitch = 0.5f + (float)newStep.ordinal() * 0.05f;
                world.playSound(null, pos, PastelSounds.REDSTONE_MECHANISM_TRIGGER, SoundSource.BLOCKS, 0.3f, pitch);
                world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue(ACTIVE_TIME, (Comparable)((Object)newStep)));
            }
            world.getBlockTicks().clearArea(new BoundingBox(pos));
            BlockState state = world.getBlockState(pos);
            this.checkTickOnNeighbor((Level)world, pos, state);
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            double x = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
            double y = (double)pos.getY() + 0.4 + (random.nextDouble() - 0.5) * 0.2;
            double z = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
            float g = -0.3f;
            double xOffset = g * (float)direction.getStepX();
            double zOffset = g * (float)direction.getStepZ();
            world.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, x + xOffset, y, z + zOffset, 0.0, 0.0, 0.0);
        }
    }

    public static enum TimingStep implements StringRepresentable
    {
        FOUR_TICKS("four_ticks", 4, "block.pastel.redstone_timer.setting.four_ticks"),
        ONE_SECOND("one_second", 20, "block.pastel.redstone_timer.setting.one_second"),
        TEN_SECONDS("ten_seconds", 200, "block.pastel.redstone_timer.setting.ten_seconds"),
        ONE_MINUTE("one_minute", 1200, "block.pastel.redstone_timer.setting.one_minute"),
        TEN_MINUTES("ten_minutes", 12000, "block.pastel.redstone_timer.setting.ten_minutes");

        public final int ticks;
        public final String localizationString;
        private final String name;

        private TimingStep(String name, int ticks, String localizationString) {
            this.name = name;
            this.ticks = ticks;
            this.localizationString = localizationString;
        }

        public TimingStep next() {
            return TimingStep.values()[(this.ordinal() + 1) % TimingStep.values().length];
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

