/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.spirit_instiller;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.client.render.MultiblockPreviewRenderer;
import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.InWorldInteractionBlock;
import earth.terrarium.pastel.blocks.spirit_instiller.SpiritInstillerBlockEntity;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconHelper;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelMultiblocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpiritInstillerBlock
extends InWorldInteractionBlock {
    public static final MapCodec<SpiritInstillerBlock> CODEC = SpiritInstillerBlock.simpleCodec(SpiritInstillerBlock::new);

    public SpiritInstillerBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends SpiritInstillerBlock> codec() {
        return CODEC;
    }

    public static void clearCurrentlyRenderedMultiBlock(Level world) {
        if (world.isClientSide) {
            ModonomiconHelper.clearRenderedMultiblock(PastelMultiblocks.get(PastelMultiblocks.SPIRIT_INSTILLER));
        }
    }

    public static boolean verifyStructure(Level level, @NotNull BlockPos blockPos, @Nullable ServerPlayer serverPlayerEntity, @NotNull SpiritInstillerBlockEntity instiller) {
        Multiblock multiblock = PastelMultiblocks.get(PastelMultiblocks.SPIRIT_INSTILLER);
        Rotation lastBlockRotation = instiller.getMultiblockRotation();
        boolean valid = false;
        int offset = -4;
        Rotation checkRotation = lastBlockRotation;
        for (int i = 0; i < Rotation.values().length; ++i) {
            valid = multiblock.validate(level, blockPos.below(1).relative(Support.directionFromRotation(checkRotation), offset), checkRotation);
            if (valid) {
                if (i == 0) break;
                instiller.setMultiblockRotation(checkRotation);
                break;
            }
            checkRotation = Rotation.values()[(checkRotation.ordinal() + 1) % Rotation.values().length];
        }
        instiller.setValidStructure(valid);
        if (valid) {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                Support.mbCriterion(sl, blockPos, multiblock);
            }
        } else if (level.isClientSide) {
            Multiblock currentMultiBlock = MultiblockPreviewRenderer.getMultiblock();
            if (currentMultiBlock == multiblock) {
                lastBlockRotation = Rotation.values()[(MultiblockPreviewRenderer.getFacingRotation().ordinal() + 1) % Rotation.values().length];
                instiller.setMultiblockRotation(lastBlockRotation);
            }
            ModonomiconHelper.renderMultiblock(PastelMultiblocks.get(PastelMultiblocks.SPIRIT_INSTILLER), PastelMultiblocks.SPIRIT_INSTILLER_TEXT, blockPos.below(2).relative(Support.directionFromRotation(lastBlockRotation), offset), lastBlockRotation);
        } else {
            SpiritInstillerBlock.scatterContents(level, blockPos);
        }
        return valid;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SpiritInstillerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return SpiritInstillerBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PastelBlockEntities.SPIRIT_INSTILLER.get()), (BlockEntityTicker)(world.isClientSide ? SpiritInstillerBlockEntity::clientTick : SpiritInstillerBlockEntity::serverTick));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world.isClientSide()) {
            SpiritInstillerBlock.clearCurrentlyRenderedMultiBlock((Level)world);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        SpiritInstillerBlockEntity spiritInstillerBlockEntity;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (world.isClientSide) {
            if (blockEntity instanceof SpiritInstillerBlockEntity) {
                SpiritInstillerBlockEntity spiritInstillerBlockEntity2 = (SpiritInstillerBlockEntity)blockEntity;
                SpiritInstillerBlock.verifyStructure(world, pos, null, spiritInstillerBlockEntity2);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (blockEntity instanceof SpiritInstillerBlockEntity && SpiritInstillerBlock.verifyStructure(world, pos, (ServerPlayer)player, spiritInstillerBlockEntity = (SpiritInstillerBlockEntity)blockEntity) && this.exchangeStack(world, pos, player, hand, handStack, spiritInstillerBlockEntity)) {
            spiritInstillerBlockEntity.setOwner(player);
            spiritInstillerBlockEntity.inventoryChanged();
        }
        return ItemInteractionResult.CONSUME;
    }
}

