/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.spirit_sallow;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class SpiritSallowLeavesBlock
extends LeavesBlock {
    public static final MapCodec<SpiritSallowLeavesBlock> CODEC = SpiritSallowLeavesBlock.simpleCodec(SpiritSallowLeavesBlock::new);

    public SpiritSallowLeavesBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends SpiritSallowLeavesBlock> codec() {
        return CODEC;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (random.nextBoolean()) {
            double startX = (float)pos.getX() + random.nextFloat();
            double startY = (double)pos.getY() + 1.01;
            double startZ = (float)pos.getZ() + random.nextFloat();
            double velocityX = 0.02 - (double)random.nextFloat() * 0.04;
            double velocityY = 0.005 + (double)random.nextFloat() * 0.01;
            double velocityZ = 0.02 - (double)random.nextFloat() * 0.04;
            world.addParticle((ParticleOptions)PastelParticleTypes.SPIRIT_SALLOW, startX, startY, startZ, velocityX, velocityY, velocityZ);
        }
    }
}

