/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.spirit_sallow;

import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface SpiritVine {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final BooleanProperty CRYSTALS = BooleanProperty.create((String)"crystals");

    public static InteractionResult pick(BlockState blockState, Level world, BlockPos blockPos) {
        if (SpiritVine.canBeHarvested(blockState)) {
            Block.popResource((Level)world, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)SpiritVine.getYieldItem(blockState), 1));
            float f = Mth.randomBetween((RandomSource)world.random, (float)0.8f, (float)1.2f);
            world.playSound(null, blockPos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, f);
            world.setBlock(blockPos, (BlockState)blockState.setValue((Property)CRYSTALS, (Comparable)Boolean.valueOf(false)), 2);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static boolean canBeHarvested(BlockState state) {
        return state.hasProperty((Property)CRYSTALS) && (Boolean)state.getValue((Property)CRYSTALS) != false;
    }

    public static Item getYieldItem(BlockState blockState) {
        if (blockState.is((Block)PastelBlocks.CYAN_SPIRIT_SALLOW_VINES.get()) || blockState.is((Block)PastelBlocks.CYAN_SPIRIT_SALLOW_VINES_PLANT.get())) {
            return (Item)PastelItems.TOPAZ_SHARD.get();
        }
        if (blockState.is((Block)PastelBlocks.MAGENTA_SPIRIT_SALLOW_VINES.get()) || blockState.is((Block)PastelBlocks.MAGENTA_SPIRIT_SALLOW_VINES_PLANT.get())) {
            return Items.AMETHYST_SHARD;
        }
        if (blockState.is((Block)PastelBlocks.YELLOW_SPIRIT_SALLOW_VINES.get()) || blockState.is((Block)PastelBlocks.YELLOW_SPIRIT_SALLOW_VINES_PLANT.get())) {
            return (Item)PastelItems.CITRINE_SHARD.get();
        }
        if (blockState.is((Block)PastelBlocks.BLACK_SPIRIT_SALLOW_VINES.get()) || blockState.is((Block)PastelBlocks.BLACK_SPIRIT_SALLOW_VINES_PLANT.get())) {
            return (Item)PastelItems.ONYX_SHARD.get();
        }
        if (blockState.is((Block)PastelBlocks.WHITE_SPIRIT_SALLOW_VINES.get()) || blockState.is((Block)PastelBlocks.WHITE_SPIRIT_SALLOW_VINES_PLANT.get())) {
            return (Item)PastelItems.MOONSTONE_SHARD.get();
        }
        return Items.AIR;
    }
}

