/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.structure;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.structure.PlayerTrackerBlockEntity;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ManxiBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<ManxiBlock> CODEC = ManxiBlock.simpleCodec(ManxiBlock::new);

    public ManxiBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends ManxiBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (!(entity instanceof PlayerTrackerBlockEntity)) {
            return InteractionResult.PASS;
        }
        PlayerTrackerBlockEntity manxi = (PlayerTrackerBlockEntity)entity;
        if (manxi.hasTaken(player)) {
            return InteractionResult.FAIL;
        }
        world.playLocalSound(pos, SoundEvents.CHISELED_BOOKSHELF_PICKUP_ENCHANTED, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        player.getInventory().placeItemBackInInventory(((Item)PastelItems.POISONERS_HANDBOOK.get()).getDefaultInstance());
        manxi.markTaken(player);
        return InteractionResult.CONSUME;
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        if (!world.isClientSide() && !player.getAbilities().instabuild) {
            player.displayClientMessage((Component)Component.translatable((String)"block.pastel.manxi.nope").withStyle(s -> s.withColor(12804078)), true);
            world.playLocalSound(pos, PastelSounds.DEEP_CRYSTAL_RING, SoundSource.BLOCKS, 1.0f, 1.5f, true);
            player.hurt(PastelDamageTypes.sleep(world, null), 6.0f);
            player.knockback(2.0, player.getX() - ((double)pos.getX() + 0.5), player.getZ() - ((double)pos.getZ() + 0.5));
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PlayerTrackerBlockEntity(pos, state);
    }
}

