/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.structure;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.structure.ManxiModel;
import earth.terrarium.pastel.blocks.structure.PlayerTrackerBlockEntity;
import earth.terrarium.pastel.blocks.structure.TreasureItemBowlBlock;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PlayerTrackingBlockEntityRenderer
implements BlockEntityRenderer<PlayerTrackerBlockEntity> {
    private static final Material TEXTURE = new Material(InventoryMenu.BLOCK_ATLAS, PastelCommon.locate("block/manxi"));
    final double radiant = Math.toRadians(360.0);
    protected static EntityRenderDispatcher dispatcher;
    private final ModelPart root;
    private final ModelPart torso;
    private final ModelPart head;

    public PlayerTrackingBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        this.root = ManxiModel.getTexturedModelData().bakeRoot();
        this.torso = this.root.getChild("root").getChild("torso");
        this.head = this.torso.getChild("head");
    }

    public void render(PlayerTrackerBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.pushPose();
        BlockState state = entity.getBlockState();
        boolean taker = entity.hasTaken((Player)Minecraft.getInstance().player);
        float time = (float)(entity.getLevel().getGameTime() % 24000L) + tickDelta;
        if (state.is((Block)PastelBlocks.MANXI.get())) {
            float f = ((Direction)state.getValue((Property)ChestBlock.FACING)).toYRot();
            double yBreath = Math.sin(time / 19.0f) * 0.02;
            double xBreath = Math.sin(time / 19.0f) * 0.0425;
            matrices.translate(0.5, 1.5, 0.5);
            matrices.mulPose(Axis.YP.rotationDegrees(-f));
            matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
            this.torso.y = (float)(1.0 - yBreath);
            this.torso.z = (float)(2.0 - yBreath / 2.0);
            this.torso.x = (float)(-xBreath);
            this.head.x = (float)((double)-0.0384f + xBreath / 2.0);
            VertexConsumer renderLayer = TEXTURE.buffer(vertexConsumers, RenderType::entityCutout);
            this.root.render(matrices, renderLayer, light, overlay);
            assert (Minecraft.getInstance().player != null);
            if (!taker) {
                matrices.translate(-0.2, 1.4 + yBreath / 6.0, -0.55);
                matrices.mulPose(Axis.XP.rotationDegrees(100.0f));
                matrices.scale(1.15f, 1.15f, 1.15f);
                Minecraft.getInstance().getItemRenderer().renderStatic(((Item)PastelItems.POISONERS_HANDBOOK.get()).getDefaultInstance(), ItemDisplayContext.GROUND, light, overlay, matrices, vertexConsumers, entity.getLevel(), 0);
            }
        } else if (state.is((Block)PastelBlocks.TREASURE_ITEM_BOWL.get()) && !taker && TreasureItemBowlBlock.canInteract((Player)Minecraft.getInstance().player)) {
            double currentRadiant = this.radiant + this.radiant * ((double)time / 16.0) / 8.0;
            double height = Math.sin(((double)time + currentRadiant) / 8.0) / 7.0;
            matrices.translate(0.5, 0.8 + height, 0.5);
            matrices.mulPose(Axis.YP.rotationDegrees(time * 2.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(((Item)PastelItems.AETHER_GRACED_NECTAR_GLOVES.get()).getDefaultInstance(), ItemDisplayContext.GROUND, light, overlay, matrices, vertexConsumers, entity.getLevel(), 0);
        }
        matrices.popPose();
    }
}

