/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.upgrade;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.upgrade.UpgradeBlockEntity;
import earth.terrarium.pastel.blocks.upgrade.Upgradeable;
import earth.terrarium.pastel.networking.s2c_payloads.ColorTransmissionPayload;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.effect.ColoredSparkleRisingParticleEffect;
import earth.terrarium.pastel.particle.effect.ColoredTransmission;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeBlock
extends BaseEntityBlock {
    protected static final VoxelShape SHAPE_UP = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    private static final List<Block> upgradeBlocks = new ArrayList<Block>();
    private final List<Vec3i> possibleUpgradeBlockOffsets = new ArrayList<Vec3i>(){
        {
            this.add(new Vec3i(3, -2, 3));
            this.add(new Vec3i(-3, -2, 3));
            this.add(new Vec3i(3, -2, -3));
            this.add(new Vec3i(-3, -2, -3));
            this.add(new Vec3i(2, 0, 2));
            this.add(new Vec3i(-2, 0, 2));
            this.add(new Vec3i(2, 0, -2));
            this.add(new Vec3i(-2, 0, -2));
            this.add(new Vec3i(3, 0, 3));
            this.add(new Vec3i(-3, 0, 3));
            this.add(new Vec3i(3, 0, -3));
            this.add(new Vec3i(-3, 0, -3));
            this.add(new Vec3i(4, -1, 4));
            this.add(new Vec3i(-4, -1, 4));
            this.add(new Vec3i(4, -1, -4));
            this.add(new Vec3i(-4, -1, -4));
            this.add(new Vec3i(1, -1, 2));
            this.add(new Vec3i(-1, -1, 2));
            this.add(new Vec3i(1, -1, -2));
            this.add(new Vec3i(-1, -1, -2));
            this.add(new Vec3i(2, -1, 1));
            this.add(new Vec3i(-2, -1, 1));
            this.add(new Vec3i(2, -1, -1));
            this.add(new Vec3i(-2, -1, -1));
        }
    };
    private final Upgradeable.UpgradeType upgradeType;
    private final int upgradeMod;
    private final int effectColor;

    public UpgradeBlock(BlockBehaviour.Properties settings, Upgradeable.UpgradeType upgradeType, int upgradeMod, int effectColor) {
        super(settings);
        this.upgradeType = upgradeType;
        this.upgradeMod = upgradeMod;
        this.effectColor = effectColor;
        upgradeBlocks.add((Block)this);
    }

    public MapCodec<? extends UpgradeBlock> codec() {
        return null;
    }

    public static List<Block> getUpgradeBlocks() {
        return upgradeBlocks;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE_UP;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.onPlace(state, world, pos, oldState, notify);
        if (!world.isClientSide) {
            this.updateConnectedUpgradeBlock((ServerLevel)world, pos);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        super.onRemove(state, world, pos, newState, moved);
        if (!world.isClientSide) {
            this.updateConnectedUpgradeBlock((ServerLevel)world, pos);
        }
    }

    private void updateConnectedUpgradeBlock(@NotNull ServerLevel world, @NotNull BlockPos pos) {
        for (Vec3i possibleUpgradeBlockOffset : this.possibleUpgradeBlockOffsets) {
            BlockPos currentPos = pos.offset(possibleUpgradeBlockOffset);
            BlockEntity blockEntity = world.getBlockEntity(currentPos);
            if (!(blockEntity instanceof Upgradeable)) continue;
            Upgradeable upgradeable = (Upgradeable)blockEntity;
            upgradeable.resetUpgrades();
            this.playConnectedParticles(world, pos, currentPos);
        }
    }

    private void playConnectedParticles(@NotNull ServerLevel world, @NotNull BlockPos pos, BlockPos currentPos) {
        int particleColor = this.getEffectColor();
        world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, PastelSounds.CRAFTING_DING, SoundSource.BLOCKS, 1.0f, 1.0f);
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, Vec3.atCenterOf((Vec3i)pos), ColoredSparkleRisingParticleEffect.of(particleColor), 10, new Vec3(0.5, 0.5, 0.5), new Vec3(0.1, 0.1, 0.1));
        ColorTransmissionPayload.playColorTransmissionParticle(world, new ColoredTransmission(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5), (PositionSource)new BlockPositionSource(currentPos), 6, particleColor));
    }

    private int getEffectColor() {
        return this.effectColor;
    }

    public Upgradeable.UpgradeType getUpgradeType() {
        return this.upgradeType;
    }

    public int getUpgradeMod() {
        return this.upgradeMod;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new UpgradeBlockEntity(pos, state);
    }
}

