/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.upgrade;

import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.blocks.upgrade.UpgradeBlock;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.progression.PastelCriteria;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Upgradeable {
    @NotNull
    public static UpgradeHolder calculateUpgradeMods4(Level world, @NotNull BlockPos blockPos, int offsetHorizontal, int offsetUp, @Nullable UUID advancementPlayerUUID) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        posList.add(blockPos.offset(offsetHorizontal, offsetUp, offsetHorizontal));
        posList.add(blockPos.offset(offsetHorizontal, offsetUp, -offsetHorizontal));
        posList.add(blockPos.offset(-offsetHorizontal, offsetUp, offsetHorizontal));
        posList.add(blockPos.offset(-offsetHorizontal, offsetUp, -offsetHorizontal));
        return Upgradeable.calculateUpgrades(world, blockPos, posList, advancementPlayerUUID);
    }

    @NotNull
    public static UpgradeHolder calculateUpgradeMods2(Level world, BlockPos blockPos, @NotNull Rotation multiblockRotation, int offsetHorizontal, int offsetUp, @Nullable UUID advancementPlayerUUID) {
        return Upgradeable.calculateUpgradeMods2(world, blockPos, multiblockRotation, offsetHorizontal, offsetHorizontal, offsetUp, advancementPlayerUUID);
    }

    @NotNull
    public static UpgradeHolder calculateUpgradeMods2(Level world, BlockPos blockPos, @NotNull Rotation multiblockRotation, int offsetSide, int offsetBack, int offsetUp, @Nullable UUID advancementPlayerUUID) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        switch (multiblockRotation) {
            case NONE: {
                positions.add(blockPos.offset(-offsetSide, offsetUp, offsetBack));
                positions.add(blockPos.offset(offsetSide, offsetUp, offsetBack));
                break;
            }
            case CLOCKWISE_90: {
                positions.add(blockPos.offset(-offsetBack, offsetUp, offsetSide));
                positions.add(blockPos.offset(-offsetBack, offsetUp, -offsetSide));
                break;
            }
            case CLOCKWISE_180: {
                positions.add(blockPos.offset(-offsetSide, offsetUp, -offsetBack));
                positions.add(blockPos.offset(offsetSide, offsetUp, -offsetBack));
                break;
            }
            default: {
                positions.add(blockPos.offset(offsetBack, offsetUp, -offsetSide));
                positions.add(blockPos.offset(offsetBack, offsetUp, offsetSide));
            }
        }
        return Upgradeable.calculateUpgrades(world, blockPos, positions, advancementPlayerUUID);
    }

    @NotNull
    private static UpgradeHolder calculateUpgrades(Level world, BlockPos blockPos, @NotNull List<BlockPos> positions, @Nullable UUID advancementPlayerUUID) {
        ServerPlayer player;
        HashMap<UpgradeType, Integer> upgradeMods = new HashMap<UpgradeType, Integer>();
        for (UpgradeType upgradeType : UpgradeType.values()) {
            upgradeMods.put(upgradeType, 0);
        }
        int upgradeCount = 0;
        for (BlockPos offsetPos : positions) {
            Block block = world.getBlockState(offsetPos).getBlock();
            if (!(block instanceof UpgradeBlock)) continue;
            UpgradeBlock upgradeBlock = (UpgradeBlock)block;
            UpgradeType upgradeType = upgradeBlock.getUpgradeType();
            int upgradeMod = upgradeBlock.getUpgradeMod();
            upgradeMods.put(upgradeType, upgradeMods.get((Object)upgradeType) + upgradeMod);
            ++upgradeCount;
        }
        if (advancementPlayerUUID != null && !world.isClientSide && (player = (ServerPlayer)PlayerOwned.getPlayerEntityIfOnline(advancementPlayerUUID)) != null) {
            PastelCriteria.UPGRADE_PLACING.trigger(player, (ServerLevel)world, blockPos, upgradeCount, upgradeMods);
        }
        return new UpgradeHolder(upgradeMods);
    }

    public void resetUpgrades();

    public void calculateUpgrades();

    public UpgradeHolder getUpgradeHolder();

    public static class UpgradeHolder {
        private final Map<UpgradeType, Integer> upgrades;

        public UpgradeHolder() {
            this.upgrades = new HashMap<UpgradeType, Integer>();
            for (UpgradeType upgradeType : UpgradeType.values()) {
                this.upgrades.put(upgradeType, 0);
            }
        }

        public UpgradeHolder(Map<UpgradeType, Integer> upgrades) {
            this.upgrades = upgrades;
        }

        public ListTag toNbt() {
            ListTag nbtList = new ListTag();
            if (!this.upgrades.isEmpty()) {
                for (Map.Entry<UpgradeType, Integer> upgrade : this.upgrades.entrySet()) {
                    if (upgrade.getValue() <= 0) continue;
                    CompoundTag upgradeCompound = new CompoundTag();
                    upgradeCompound.putString("Variant", upgrade.getKey().toString());
                    upgradeCompound.putFloat("Power", (float)upgrade.getValue().intValue());
                    nbtList.add((Object)upgradeCompound);
                }
            }
            return nbtList;
        }

        public static UpgradeHolder fromNbt(@NotNull ListTag nbtList) {
            HashMap<UpgradeType, Integer> map = new HashMap<UpgradeType, Integer>();
            for (UpgradeType upgradeType : UpgradeType.values()) {
                map.put(upgradeType, 0);
            }
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag nbtCompound = nbtList.getCompound(i);
                UpgradeType upgradeType = UpgradeType.valueOf(nbtCompound.getString("Variant"));
                int upgradeMod = nbtCompound.getInt("Power");
                map.put(upgradeType, upgradeMod);
            }
            return new UpgradeHolder(map);
        }

        public int getRawValue(UpgradeType upgradeType) {
            return this.upgrades.get((Object)upgradeType);
        }

        public float getEffectiveValue(UpgradeType upgradeType) {
            return 1.0f + (float)this.upgrades.get((Object)upgradeType).intValue() / (float)upgradeType.getEffectivityDivisor();
        }

        public int getSpeedDelta(RandomSource random) {
            return Support.chanceRound(this.getEffectiveValue(UpgradeType.SPEED), random);
        }

        public long getEffectiveCost(UpgradeType upgradeType) {
            return 1L << this.upgrades.get((Object)upgradeType);
        }

        public long getEffectiveCostUsingEfficiency(UpgradeType upgradeType) {
            int efficiencyMod = this.getRawValue(UpgradeType.EFFICIENCY);
            return 1L << Math.max(this.upgrades.get((Object)upgradeType) - efficiencyMod, 0);
        }

        public long getEffectiveCostUsingEfficiency(long amount) {
            int efficiencyMod = this.getRawValue(UpgradeType.EFFICIENCY);
            return Math.max(1L, amount >> efficiencyMod);
        }

        public Iterable<? extends Map.Entry<UpgradeType, Integer>> entrySet() {
            return this.upgrades.entrySet();
        }
    }

    public static enum UpgradeType {
        SPEED(1),
        EFFICIENCY(16),
        YIELD(16),
        EXPERIENCE(1);

        private final int effectivityDivisor;

        private UpgradeType(int effectivityDivisor) {
            this.effectivityDivisor = effectivityDivisor;
        }

        public int getEffectivityDivisor() {
            return this.effectivityDivisor;
        }
    }
}

