/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.capabilities.fluid;

import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidHandlerView
implements IFluidHandler {
    private final IFluidHandler delegator;
    private boolean supportsInsertion = true;
    private boolean supportsExtraction = true;

    public FluidHandlerView(IFluidHandler delegator) {
        this.delegator = delegator;
    }

    public FluidHandlerView disableExtraction() {
        this.supportsExtraction = false;
        return this;
    }

    public FluidHandlerView disableInsertion() {
        this.supportsInsertion = false;
        return this;
    }

    public int getTanks() {
        return this.delegator.getTanks();
    }

    public FluidStack getFluidInTank(int i) {
        return this.delegator.getFluidInTank(i);
    }

    public int getTankCapacity(int i) {
        return this.delegator.getTankCapacity(i);
    }

    public boolean isFluidValid(int i, FluidStack fluidStack) {
        return this.delegator.isFluidValid(i, fluidStack);
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        if (!this.supportsInsertion) {
            return 0;
        }
        return this.delegator.fill(fluidStack, fluidAction);
    }

    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        if (!this.supportsExtraction) {
            return FluidStack.EMPTY;
        }
        return this.delegator.drain(fluidStack, fluidAction);
    }

    public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
        if (!this.supportsExtraction) {
            return FluidStack.EMPTY;
        }
        return this.delegator.drain(i, fluidAction);
    }
}

