/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import earth.terrarium.pastel.entity.spawners.ShootingStarSpawner;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ShootingStarCommand {
    public static void register(LiteralCommandNode<CommandSourceStack> root) {
        LiteralCommandNode spawnShootingStar = ((LiteralArgumentBuilder)Commands.literal((String)"spawn_shooting_star").requires(source -> source.hasPermission(2))).build();
        ArgumentCommandNode targets = ((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(context -> ShootingStarCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), 1))).build();
        ArgumentCommandNode targetsAmount = ((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ShootingStarCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))).build();
        targets.addChild((CommandNode)targetsAmount);
        spawnShootingStar.addChild((CommandNode)targets);
        root.addChild((CommandNode)spawnShootingStar);
    }

    private static int execute(CommandSourceStack source, Collection<? extends ServerPlayer> targets, int amount) {
        for (ServerPlayer serverPlayer : targets) {
            for (int i = 0; i < amount; ++i) {
                ShootingStarSpawner.spawnShootingStar((ServerLevel)serverPlayer.level(), (Player)serverPlayer);
            }
        }
        source.sendSuccess(() -> Component.translatable((String)"commands.pastel.spawn_shooting_star.success", (Object[])new Object[]{amount}), false);
        return amount;
    }
}

