/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI;

import earth.terrarium.pastel.api.recipe.IngredientStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.NotNull;

public class REIHelper {
    public static List<EntryIngredient> toEntryIngredients(List<IngredientStack> ingredientStacks) {
        return ingredientStacks.stream().map(REIHelper::ofIngredientStack).collect(Collectors.toCollection(ArrayList::new));
    }

    public static EntryIngredient ofIngredientStack(@NotNull IngredientStack ingredientStack) {
        return EntryIngredients.ofItemStacks(ingredientStack.getItems().toList());
    }

    public static EntryIngredient ofFluidIngredient(FluidIngredient fluidIngredient) {
        Stream<EntryStack> fluids = Arrays.stream(fluidIngredient.getStacks()).map(stack -> EntryStacks.of((Fluid)stack.getFluid(), (long)stack.getAmount()));
        return EntryIngredient.of(fluids.toList());
    }
}

