/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.compat.REI.plugins.EnchanterDisplay;
import earth.terrarium.pastel.items.magic_items.KnowledgeGemItem;
import earth.terrarium.pastel.recipe.GatedPastelRecipe;
import earth.terrarium.pastel.recipe.enchanter.EnchanterCraftingRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class EnchanterEnchantingDisplay
extends EnchanterDisplay {
    protected final int requiredExperience;
    protected final int craftingTime;

    public EnchanterEnchantingDisplay(@NotNull RecipeHolder<EnchanterCraftingRecipe> recipe) {
        super((RecipeHolder<? extends GatedPastelRecipe<?>>)recipe, EnchanterEnchantingDisplay.buildIngredients((EnchanterCraftingRecipe)recipe.value()), Collections.singletonList(EntryIngredients.of((ItemStack)((EnchanterCraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)BasicDisplay.registryAccess()))));
        this.requiredExperience = ((EnchanterCraftingRecipe)recipe.value()).getRequiredExperience();
        this.craftingTime = ((EnchanterCraftingRecipe)recipe.value()).getCraftingTime(1.0);
    }

    private static List<EntryIngredient> buildIngredients(EnchanterCraftingRecipe recipe) {
        List inputs = recipe.getIngredients().stream().map(EntryIngredients::ofIngredient).collect(Collectors.toCollection(ArrayList::new));
        inputs.add(EntryIngredients.of((ItemStack)KnowledgeGemItem.getKnowledgeDropStackWithXP(recipe.getRequiredExperience(), true)));
        return inputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return PastelPlugins.ENCHANTER_CRAFTING;
    }

    @Override
    public boolean isUnlocked() {
        Minecraft client = Minecraft.getInstance();
        return DatabankUtils.hasAdvancement((Player)client.player, (ResourceLocation)EnchanterCraftingRecipe.UNLOCK_IDENTIFIER) && super.isUnlocked();
    }
}

