/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.compat.REI.PastelDisplay;
import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.compat.REI.REIHelper;
import earth.terrarium.pastel.recipe.pedestal.PastelGemstoneColor;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class PedestalCraftingDisplay
extends PastelDisplay {
    protected final PedestalTier pedestalRecipeTier;
    protected final int width;
    protected final int height;
    protected final float experience;
    protected final int craftingTime;
    public boolean shapeless;

    public PedestalCraftingDisplay(RecipeHolder<PedestalRecipe> recipe) {
        super(recipe, PedestalCraftingDisplay.mapIngredients((PedestalRecipe)recipe.value()), Collections.singletonList(EntryIngredients.of((ItemStack)((PedestalRecipe)recipe.value()).getResultItem((HolderLookup.Provider)BasicDisplay.registryAccess()))));
        this.pedestalRecipeTier = ((PedestalRecipe)recipe.value()).getTier();
        this.width = ((PedestalRecipe)recipe.value()).getWidth();
        this.height = ((PedestalRecipe)recipe.value()).getHeight();
        this.experience = ((PedestalRecipe)recipe.value()).getExperience();
        this.craftingTime = ((PedestalRecipe)recipe.value()).getCraftingTime();
        this.shapeless = ((PedestalRecipe)recipe.value()).isShapeless();
    }

    private static List<EntryIngredient> mapIngredients(PedestalRecipe recipe) {
        int i;
        int powderSlotCount = recipe.getTier().getPowderSlotCount();
        List<IngredientStack> ingredients = recipe.getIngredientStacks();
        int ingredientCount = ingredients.size();
        NonNullList list = NonNullList.withSize((int)(9 + powderSlotCount), (Object)EntryIngredient.empty());
        for (i = 0; i < ingredientCount; ++i) {
            list.set(recipe.getGridSlotId(i), REIHelper.ofIngredientStack(recipe.getIngredientStacks().get(i)));
        }
        for (i = 0; i < powderSlotCount; ++i) {
            PastelGemstoneColor color = PastelGemstoneColor.values()[i];
            int powderAmount = recipe.getPowderInputs().getOrDefault(color, 0);
            if (powderAmount <= 0) continue;
            list.set(9 + i, EntryIngredients.of((ItemLike)color.getPowder(), (int)powderAmount));
        }
        return list;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return PastelPlugins.PEDESTAL_CRAFTING;
    }

    @Override
    public boolean isUnlocked() {
        Minecraft client = Minecraft.getInstance();
        return this.pedestalRecipeTier.hasUnlocked((Player)client.player) && super.isUnlocked();
    }

    public PedestalTier getTier() {
        return this.pedestalRecipeTier;
    }
}

