/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.botania;

import earth.terrarium.pastel.api.color.ItemColors;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.interaction.ItemProvider;
import earth.terrarium.pastel.compat.PastelIntegrationPacks;
import earth.terrarium.pastel.compat.botania.BlackestLotusItem;
import earth.terrarium.pastel.compat.botania.LeastBlackLotusItem;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import vazkii.botania.common.item.BlackHoleTalismanItem;
import vazkii.botania.common.item.BotaniaItems;

public class BotaniaCompat
extends PastelIntegrationPacks.ModIntegrationPack {
    public static DeferredItem<Item> LEAST_BLACK_LOTUS = PastelItems.register(PastelItems.simple(PastelItems.item("least_black_lotus", () -> new LeastBlackLotusItem(new Item.Properties()), InkColors.BLACK)));
    public static DeferredItem<Item> BLACKEST_LOTUS = PastelItems.register(PastelItems.simple(PastelItems.item("blackest_lotus", () -> new BlackestLotusItem(new Item.Properties()), InkColors.BLACK)));

    private static void onServerStarted(ServerStartedEvent event) {
        ItemColors.ITEM_COLORS.registerColorMapping(BotaniaItems.overgrowthSeed, InkColors.LIME);
        ItemColors.ITEM_COLORS.registerColorMapping(BotaniaItems.blackLotus, InkColors.BLACK);
        ItemColors.ITEM_COLORS.registerColorMapping(BotaniaItems.blackerLotus, InkColors.BLACK);
        ItemColors.ITEM_COLORS.registerColorMapping(BotaniaItems.terrasteel, InkColors.LIME);
    }

    private static void onRegisterCaps(RegisterCapabilitiesEvent event) {
        event.registerItem(ItemProvider.CAPABILITY, (ignored, ignored2) -> new ItemProvider(){

            @Override
            public int getItemCount(Player player, ItemStack stack, Item requestedItem) {
                if (requestedItem instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)requestedItem;
                    Block storedBlock = BlackHoleTalismanItem.getBlock((ItemStack)stack);
                    if (blockItem.getBlock() == storedBlock) {
                        return BlackHoleTalismanItem.getBlockCount((ItemStack)stack);
                    }
                }
                return 0;
            }

            @Override
            public int provideItems(Player player, ItemStack stack, Item requestedItem, int amount) {
                if (requestedItem instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)requestedItem;
                    Block storedBlock = BlackHoleTalismanItem.getBlock((ItemStack)stack);
                    if (blockItem.getBlock() == storedBlock) {
                        int storedAmount = BlackHoleTalismanItem.getBlockCount((ItemStack)stack);
                        int amountToRemove = Math.min(storedAmount, amount);
                        BlackHoleTalismanItem.setCount((ItemStack)stack, (int)(storedAmount - amountToRemove));
                        return amountToRemove;
                    }
                }
                return 0;
            }
        }, new ItemLike[]{BotaniaItems.blackHoleTalisman});
    }

    @Override
    public void register() {
        NeoForge.EVENT_BUS.addListener(BotaniaCompat::onServerStarted);
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(BotaniaCompat::onRegisterCaps);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
    }
}

