/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.emi.widgets;

import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Tuple;

public class DynamicTextWidget
extends TextWidget {
    private static final Minecraft CLIENT = Minecraft.getInstance();
    private final Function<Minecraft, Tuple<FormattedCharSequence, Integer>> textSupplier;

    public DynamicTextWidget(Function<Minecraft, Tuple<FormattedCharSequence, Integer>> textSupplier, int x, int y, boolean shadow) {
        super((FormattedCharSequence)textSupplier.apply(CLIENT).getA(), x, y, 0, shadow);
        this.textSupplier = textSupplier;
    }

    public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)draw);
        context.push();
        int xOff = this.horizontalAlignment.offset(DynamicTextWidget.CLIENT.font.width(this.text));
        Objects.requireNonNull(DynamicTextWidget.CLIENT.font);
        int yOff = this.verticalAlignment.offset(9);
        context.matrices().translate((float)xOff, (float)yOff, 300.0f);
        Tuple<FormattedCharSequence, Integer> pair = this.textSupplier.apply(CLIENT);
        if (this.shadow) {
            context.drawTextWithShadow((FormattedCharSequence)pair.getA(), this.x, this.y, ((Integer)pair.getB()).intValue());
        } else {
            context.drawText((FormattedCharSequence)pair.getA(), this.x, this.y, ((Integer)pair.getB()).intValue());
        }
        context.pop();
    }
}

