/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.exclusions_lib;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ExclusionsLibCompat {
    public static final DeferredRegister<BlockPredicateType<?>> REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_PREDICATE_TYPE, (String)"exclusions_lib");

    public static void registerNotPresent(IEventBus bus) {
        ExclusionsLibCompat.registerBlockPredicate("overlaps_structure", AlwaysFalseBlockPredicate.CODEC);
        REGISTRY.register(bus);
    }

    private static <P extends BlockPredicate> void registerBlockPredicate(String id, MapCodec<P> codec) {
        REGISTRY.register(id, () -> () -> codec);
    }

    public static class AlwaysFalseBlockPredicate
    implements BlockPredicate {
        public static AlwaysFalseBlockPredicate instance = new AlwaysFalseBlockPredicate();
        public static final MapCodec<AlwaysFalseBlockPredicate> CODEC = MapCodec.unit(() -> instance);

        private AlwaysFalseBlockPredicate() {
        }

        public boolean test(WorldGenLevel structureWorldAccess, BlockPos blockPos) {
            return false;
        }

        public BlockPredicateType<?> type() {
            return BlockPredicateType.TRUE;
        }
    }
}

