/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.client.pages;

import com.cmdpro.databank.DatabankUtils;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconHelper;
import earth.terrarium.pastel.compat.modonomicon.pages.BookHintPage;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.networking.c2s_payloads.GuidebookHintBoughtPayload;
import earth.terrarium.pastel.sound.HintRevelationSoundInstance;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class BookHintPageRenderer
extends BookPageRenderer<BookHintPage>
implements PageWithTextRenderer {
    private Style OBFUSCATED_STYLE;
    private HintRevelationSoundInstance soundInstance;
    @Nullable
    private BookTextHolder obfuscatedText;
    long lastRevealTime = 0L;
    int revealProgress;

    public BookHintPageRenderer(BookHintPage page) {
        super((BookPage)page);
    }

    public void onBeginDisplayPage(BookEntryScreen parentScreen, int left, int top) {
        super.onBeginDisplayPage(parentScreen, left, top);
        this.OBFUSCATED_STYLE = Style.EMPTY.withColor(TextColor.fromRgb((int)0)).withBold(Boolean.valueOf(false)).withItalic(Boolean.valueOf(false)).withUnderlined(Boolean.valueOf(false)).withStrikethrough(Boolean.valueOf(false)).withObfuscated(Boolean.valueOf(true)).withClickEvent(null).withHoverEvent(null).withInsertion(null).withFont(((BookHintPage)this.page).getBook().getFont());
        this.obfuscatedText = null;
        boolean isDone = DatabankUtils.hasAdvancement((Player)Minecraft.getInstance().player, (ResourceLocation)((BookHintPage)this.page).getCompletionAdvancement());
        if (!isDone) {
            this.revealProgress = -1;
            this.addButton(new PaymentButtonWidget(2, 133, 112, 20, (Component)Component.empty(), this::paymentButtonClicked, this));
        } else {
            this.revealProgress = 0;
        }
    }

    private BookTextHolder splitObfuscateText(BookTextHolder text) {
        if (text.hasComponent()) {
            ArrayList<MutableComponent> newText = new ArrayList<MutableComponent>(1);
            newText.add(this.splitObfuscateText(text.getComponent().copy()));
            return new RenderedBookTextHolder(text, newText);
        }
        if (text instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)text;
            ArrayList<MutableComponent> newRenderedText = new ArrayList<MutableComponent>(renderedText.getRenderedText().size());
            for (MutableComponent mutableText : renderedText.getRenderedText()) {
                newRenderedText.add(this.splitObfuscateText(mutableText));
            }
            return new RenderedBookTextHolder(text, newRenderedText);
        }
        return BookTextHolder.EMPTY;
    }

    private MutableComponent splitObfuscateText(MutableComponent text) {
        MutableComponent out = Component.empty();
        text.getVisualOrderText().accept((index, style, codepoint) -> {
            String charStr = String.valueOf((char)codepoint);
            out.append((Component)Component.empty().append((Component)Component.literal((String)charStr).setStyle(this.OBFUSCATED_STYLE)).setStyle(style));
            return true;
        });
        return out;
    }

    private MutableComponent floodStyle(Component text, Style style) {
        MutableComponent out = MutableComponent.create((ComponentContents)text.getContents()).setStyle(style);
        for (Component sibling : text.getSiblings()) {
            out.append((Component)this.floodStyle(sibling, style));
        }
        return out;
    }

    private BookTextHolder obfuscateText(BookTextHolder text, @Nullable BookTextHolder splitText, int start) {
        if (this.mc.level == null) {
            return BookTextHolder.EMPTY;
        }
        if (this.revealProgress == 0) {
            return text;
        }
        if (this.revealProgress == -1) {
            if (splitText != null) {
                return splitText;
            }
            if (text.hasComponent()) {
                return new BookTextHolder((Component)this.floodStyle(text.getComponent(), this.OBFUSCATED_STYLE));
            }
            if (text instanceof RenderedBookTextHolder) {
                RenderedBookTextHolder renderedText = (RenderedBookTextHolder)text;
                List<MutableComponent> mutableTexts = renderedText.getRenderedText().stream().map(mutableText -> this.floodStyle((Component)mutableText, this.OBFUSCATED_STYLE)).toList();
                return new RenderedBookTextHolder((BookTextHolder)renderedText, mutableTexts);
            }
        }
        if (this.revealProgress == 1 || this.revealProgress + 1 == start) {
            splitText = this.splitObfuscateText(text);
        }
        if (this.revealProgress < start) {
            return splitText;
        }
        if (splitText instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)splitText;
            int c = 0;
            List mutableTexts = renderedText.getRenderedText();
            for (int i = 0; i < mutableTexts.size(); ++i) {
                MutableComponent mutableText2 = (MutableComponent)mutableTexts.get(i);
                if (c + mutableText2.getSiblings().size() > this.revealProgress - start) {
                    MutableComponent newMutableText = Component.empty();
                    for (int s = 0; s < mutableText2.getSiblings().size(); ++s) {
                        Component sibling = (Component)mutableText2.getSiblings().get(s);
                        newMutableText.append((Component)(c + s == this.revealProgress - start && sibling.getSiblings().size() == 1 ? ((Component)sibling.getSiblings().getFirst()).copy().setStyle(sibling.getStyle()) : sibling));
                    }
                    mutableTexts.set(i, newMutableText);
                    break;
                }
                c += mutableText2.getSiblings().size();
            }
        }
        return splitText;
    }

    private boolean isDoneRevealing(BookTextHolder obfText) {
        if (obfText instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)obfText;
            List mutableTexts = renderedText.getRenderedText();
            MutableComponent lastText = (MutableComponent)mutableTexts.getLast();
            List siblings = lastText.getSiblings();
            Component lastSibling = (Component)siblings.getLast();
            return lastSibling.getSiblings().isEmpty();
        }
        return true;
    }

    protected void paymentButtonClicked(Button button) {
        if (this.mc.player == null || this.mc.level == null) {
            return;
        }
        if (this.revealProgress > -1) {
            return;
        }
        if (this.mc.player.isCreative() || InventoryHelper.hasIngredientStacksInInventory(List.of(((BookHintPage)this.page).getCost()), (IItemHandlerModifiable)new InvWrapper((Container)this.mc.player.getInventory()))) {
            this.soundInstance = new HintRevelationSoundInstance((Player)this.mc.player);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)this.soundInstance);
            PacketDistributor.sendToServer((CustomPacketPayload)new GuidebookHintBoughtPayload(((BookHintPage)this.page).getCompletionAdvancement(), ((BookHintPage)this.page).getCost()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.revealProgress = 1;
            this.lastRevealTime = this.mc.level.getGameTime();
            this.mc.player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        }
    }

    public int getTextY() {
        if (((BookHintPage)this.page).hasTitle()) {
            return ((BookHintPage)this.page).showTitleSeparator() ? 17 : 7;
        }
        return -4;
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float ticks) {
        if (this.mc.level == null) {
            return;
        }
        this.renderTitle(drawContext, ((BookHintPage)this.page).getTitle(), ((BookHintPage)this.page).showTitleSeparator(), 62, 0);
        int textStart = 1;
        this.obfuscatedText = this.obfuscateText(((BookHintPage)this.page).getText(), this.obfuscatedText, textStart);
        this.renderBookTextHolder(drawContext, this.obfuscatedText, 0, this.getTextY(), 124);
        Style style = this.getClickedComponentStyleAt(mouseX, mouseY);
        if (style != null) {
            this.parentScreen.renderComponentHoverEffect(drawContext, style, mouseX, mouseY);
        }
        if (this.revealProgress == -1) {
            ModonomiconHelper.renderIngredientStack(drawContext, this.parentScreen, 91, 134, mouseX, mouseY, ((BookHintPage)this.page).getCost());
        }
        if (this.revealProgress > 0) {
            long currentTime = System.currentTimeMillis() / 20L;
            if (this.isDoneRevealing(this.obfuscatedText)) {
                this.soundInstance.setDone();
                this.revealProgress = 0;
                this.obfuscatedText = null;
            } else if (currentTime != this.lastRevealTime) {
                this.lastRevealTime = currentTime;
                ++this.revealProgress;
            }
        }
    }

    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        if (pMouseX > 0.0 && pMouseY > 0.0) {
            Style titleStyle;
            if (((BookHintPage)this.page).hasTitle() && (titleStyle = this.getClickedComponentStyleAtForTitle(((BookHintPage)this.page).getTitle(), 62, 0, pMouseX, pMouseY)) != null) {
                return titleStyle;
            }
            Style textStyle = this.getClickedComponentStyleAtForTextHolder(this.obfuscatedText, 0, this.getTextY(), 124, pMouseX, pMouseY);
            if (textStyle != null) {
                return textStyle;
            }
        }
        return super.getClickedComponentStyleAt(pMouseX, pMouseY);
    }

    public static class PaymentButtonWidget
    extends Button {
        final BookHintPageRenderer pageRenderer;

        public PaymentButtonWidget(int x, int y, int width, int height, Component message, Button.OnPress onPress, BookHintPageRenderer pageRenderer) {
            super(x, y, width, height, message, onPress, Button.DEFAULT_NARRATION);
            this.pageRenderer = pageRenderer;
            this.setMessage((Component)Component.translatable((String)"pastel.gui.guidebook.reveal_hint_button.text"));
        }

        protected void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            if (this.pageRenderer.revealProgress < 0) {
                super.renderWidget(drawContext, mouseX, mouseY, delta);
            }
        }
    }
}

