/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.client.pages;

import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.mojang.blaze3d.systems.RenderSystem;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconHelper;
import earth.terrarium.pastel.compat.modonomicon.client.pages.BookGatedRecipePageRenderer;
import earth.terrarium.pastel.compat.modonomicon.pages.BookGatedRecipePage;
import earth.terrarium.pastel.recipe.titration_barrel.TitrationBarrelRecipe;
import earth.terrarium.pastel.render.FluidRendering;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

public class BookTitrationBarrelFermentingPageRenderer
extends BookGatedRecipePageRenderer<TitrationBarrelRecipe, BookGatedRecipePage<TitrationBarrelRecipe>> {
    private static final ResourceLocation BACKGROUND_TEXTURE = PastelCommon.locate("textures/gui/modonomicon/titration_barrel.png");
    private final BookTextHolder durationText1;
    private final BookTextHolder durationText2;

    public BookTitrationBarrelFermentingPageRenderer(BookGatedRecipePage<TitrationBarrelRecipe> page) {
        super(page);
        RecipeHolder recipe1 = page.getRecipe1();
        RecipeHolder recipe2 = page.getRecipe2();
        ResourceLocation font = BookDataManager.Client.get().safeFont(((BookGatedRecipePage)this.page).getBook().getFont());
        this.durationText1 = recipe1 == null ? null : new BookTextHolder((Component)TitrationBarrelRecipe.getDurationText(((TitrationBarrelRecipe)recipe1.value()).getMinFermentationTimeHours(), ((TitrationBarrelRecipe)recipe1.value()).getFermentationData()).withStyle(s -> s.withFont(font)));
        this.durationText2 = recipe2 == null ? null : new BookTextHolder((Component)TitrationBarrelRecipe.getDurationText(((TitrationBarrelRecipe)recipe2.value()).getMinFermentationTimeHours(), ((TitrationBarrelRecipe)recipe2.value()).getFermentationData()).withStyle(s -> s.withFont(font)));
    }

    protected int getRecipeHeight() {
        return 70;
    }

    protected void drawRecipe(GuiGraphics drawContext, RecipeHolder<TitrationBarrelRecipe> recipeEntry, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        TitrationBarrelRecipe recipe = (TitrationBarrelRecipe)recipeEntry.value();
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        RenderSystem.enableBlend();
        drawContext.blit(BACKGROUND_TEXTURE, recipeX - 2, recipeY - 2, 0.0f, 0.0f, 100, 32, 128, 256);
        this.renderTitle(drawContext, recipeY, second);
        FluidIngredient fluid = recipe.getFluidInput();
        boolean usesFluid = !fluid.isEmpty();
        IngredientStack bucketStack = IngredientStack.EMPTY;
        if (usesFluid) {
            bucketStack = IngredientStack.of(FluidRendering.fluidBucketIngredient(recipe.getFluidInput()));
        }
        List<IngredientStack> ingredients = recipe.getIngredientStacks();
        int ingredientSize = ingredients.size();
        int ingredientSizeWithFluid = usesFluid ? ingredientSize + 1 : ingredientSize;
        int startX = recipeX + Math.max(-5, 15 - ingredientSizeWithFluid * 10);
        int startY = recipeY + (ingredientSizeWithFluid > 3 ? 0 : 10);
        for (int i = 0; i < ingredientSizeWithFluid; ++i) {
            int yOffset;
            int xOffset;
            IngredientStack currentIngredient;
            IngredientStack ingredientStack = currentIngredient = i == ingredientSize ? bucketStack : ingredients.get(i);
            if (i < 3) {
                xOffset = i * 18;
                yOffset = 0;
            } else {
                xOffset = (i - 3) * 18;
                yOffset = 18;
            }
            ModonomiconHelper.renderIngredientStack(drawContext, this.parentScreen, startX + xOffset, startY + yOffset, mouseX, mouseY, currentIngredient);
        }
        if (recipe.getTappingItem() == Items.AIR) {
            this.parentScreen.renderItemStack(drawContext, recipeX + 54, recipeY + 20, mouseX, mouseY, recipe.getToastSymbol());
        } else {
            this.parentScreen.renderItemStack(drawContext, recipeX + 50, recipeY + 20, mouseX, mouseY, recipe.getToastSymbol());
            this.parentScreen.renderItemStack(drawContext, recipeX + 60, recipeY + 20, mouseX, mouseY, recipe.getTappingItem().getDefaultInstance());
        }
        this.parentScreen.renderItemStack(drawContext, recipeX + 78, recipeY + 10, mouseX, mouseY, recipe.getResultItem((HolderLookup.Provider)world.registryAccess()));
        if (!second && this.durationText1 != null) {
            this.renderBookTextHolder(drawContext, this.durationText1, 0, recipeY + 40, 124);
        }
        if (second && this.durationText2 != null) {
            this.renderBookTextHolder(drawContext, this.durationText2, 0, recipeY + 40, 124);
        }
    }
}

