/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.pages;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconCompat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class BookChecklistPage
extends BookTextPage {
    private final Map<ResourceLocation, BookTextHolder> checklist;

    public BookChecklistPage(BookTextHolder title, BookTextHolder text, boolean useMarkdownInTitle, boolean showTitleSeparator, String anchor, BookCondition condition, Map<ResourceLocation, BookTextHolder> checklist) {
        super(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition);
        this.checklist = checklist;
    }

    public static BookChecklistPage fromJson(ResourceLocation entryId, JsonObject json, HolderLookup.Provider provider) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"title", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        boolean useMarkdownInTitle = GsonHelper.getAsBoolean((JsonObject)json, (String)"use_markdown_title", (boolean)false);
        boolean showTitleSeparator = GsonHelper.getAsBoolean((JsonObject)json, (String)"show_title_separator", (boolean)true);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"text", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        String anchor = GsonHelper.getAsString((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson((ResourceLocation)entryId, (JsonObject)json.getAsJsonObject("condition"), (HolderLookup.Provider)provider) : new BookNoneCondition();
        JsonObject checklistObject = GsonHelper.getAsJsonObject((JsonObject)json, (String)"checklist", (JsonObject)new JsonObject());
        LinkedHashMap<ResourceLocation, BookTextHolder> checklist = new LinkedHashMap<ResourceLocation, BookTextHolder>();
        for (String key : checklistObject.keySet()) {
            BookTextHolder value = BookGsonHelper.getAsBookTextHolder((JsonObject)checklistObject, (String)key, (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
            checklist.put(ResourceLocation.parse((String)key), value);
        }
        return new BookChecklistPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, (BookCondition)condition, checklist);
    }

    public static BookChecklistPage fromNetwork(RegistryFriendlyByteBuf buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
        boolean useMarkdownInTitle = buffer.readBoolean();
        boolean showTitleSeparator = buffer.readBoolean();
        BookTextHolder text = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
        String anchor = buffer.readUtf();
        BookCondition condition = BookCondition.fromNetwork((RegistryFriendlyByteBuf)buffer);
        int checklistSize = buffer.readVarInt();
        LinkedHashMap checklist = Maps.newLinkedHashMapWithExpectedSize((int)checklistSize);
        for (int i = 0; i < checklistSize; ++i) {
            ResourceLocation key = buffer.readResourceLocation();
            BookTextHolder value = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
            checklist.put(key, value);
        }
        return new BookChecklistPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition, checklist);
    }

    public Map<ResourceLocation, BookTextHolder> getChecklist() {
        return this.checklist;
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        ArrayList<MutableComponent> mutableTexts = new ArrayList<MutableComponent>();
        int i = 1;
        for (Map.Entry<ResourceLocation, BookTextHolder> entry : this.checklist.entrySet()) {
            BookTextHolder entryText = entry.getValue();
            List rendered = textRenderer.render(entryText.getString());
            MutableComponent parent = Component.literal((String)String.format("%d. ", i));
            for (MutableComponent mutableText : rendered) {
                parent.append((Component)mutableText);
            }
            parent.append((Component)Component.literal((String)""));
            mutableTexts.add(parent);
            ++i;
        }
        BookTextHolder bookTextHolder = this.text;
        if (bookTextHolder instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)bookTextHolder;
            mutableTexts.addAll(renderedText.getRenderedText());
        } else {
            mutableTexts.add(this.text.getComponent().copy());
        }
        this.text = new RenderedBookTextHolder(new BookTextHolder(""), mutableTexts);
    }

    public ResourceLocation getType() {
        return ModonomiconCompat.CHECKLIST_PAGE;
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        super.toNetwork(buffer);
        buffer.writeVarInt(this.checklist.size());
        for (Map.Entry<ResourceLocation, BookTextHolder> entry : this.checklist.entrySet()) {
            buffer.writeResourceLocation(entry.getKey());
            entry.getValue().toNetwork(buffer);
        }
    }
}

