/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.pages;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconCompat;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class BookHintPage
extends BookTextPage {
    private final ResourceLocation completionAdvancement;
    private final IngredientStack cost;

    public BookHintPage(BookTextHolder title, BookTextHolder text, boolean useMarkdownInTitle, boolean showTitleSeparator, String anchor, BookCondition condition, ResourceLocation completionAdvancement, IngredientStack cost) {
        super(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition);
        this.completionAdvancement = completionAdvancement;
        this.cost = cost;
    }

    public static BookHintPage fromJson(ResourceLocation entryId, JsonObject json, HolderLookup.Provider provider) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"title", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        boolean useMarkdownInTitle = GsonHelper.getAsBoolean((JsonObject)json, (String)"use_markdown_title", (boolean)false);
        boolean showTitleSeparator = GsonHelper.getAsBoolean((JsonObject)json, (String)"show_title_separator", (boolean)true);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"text", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        String anchor = GsonHelper.getAsString((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson((ResourceLocation)entryId, (JsonObject)json.getAsJsonObject("condition"), (HolderLookup.Provider)provider) : new BookNoneCondition();
        ResourceLocation completionAdvancement = ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)json, (String)"completion_advancement"));
        IngredientStack cost = IngredientStack.EMPTY;
        if (json.has("cost")) {
            JsonObject ingredient = GsonHelper.getAsJsonObject((JsonObject)json, (String)"cost");
            cost = IngredientStack.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)ingredient).result().orElse(cost);
        }
        return new BookHintPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, (BookCondition)condition, completionAdvancement, cost);
    }

    public static BookHintPage fromNetwork(RegistryFriendlyByteBuf buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
        boolean useMarkdownInTitle = buffer.readBoolean();
        boolean showTitleSeparator = buffer.readBoolean();
        BookTextHolder text = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
        String anchor = buffer.readUtf();
        BookCondition condition = BookCondition.fromNetwork((RegistryFriendlyByteBuf)buffer);
        ResourceLocation completionAdvancement = buffer.readResourceLocation();
        IngredientStack cost = (IngredientStack)IngredientStack.STREAM_CODEC.decode((Object)buffer);
        return new BookHintPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition, completionAdvancement, cost);
    }

    public ResourceLocation getCompletionAdvancement() {
        return this.completionAdvancement;
    }

    public IngredientStack getCost() {
        return this.cost;
    }

    public ResourceLocation getType() {
        return ModonomiconCompat.HINT_PAGE;
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        super.toNetwork(buffer);
        buffer.writeResourceLocation(this.completionAdvancement);
        IngredientStack.STREAM_CODEC.encode((Object)buffer, (Object)this.cost);
    }
}

